/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.selector;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.NeighborProviderIndex;
import software.amazon.smithy.model.selector.InternalSelector;
import software.amazon.smithy.model.shapes.Shape;

final class Context {
    NeighborProviderIndex neighborIndex;
    private final Model model;
    private final Map<String, Set<Shape>> variables = new HashMap<String, Set<Shape>>();
    private final List<Set<Shape>> roots;

    Context(Model model, NeighborProviderIndex neighborIndex, List<Set<Shape>> roots) {
        this.model = model;
        this.neighborIndex = neighborIndex;
        this.roots = roots;
    }

    Map<String, Set<Shape>> getVars() {
        return this.variables;
    }

    Set<Shape> getRootResult(int index) {
        return this.roots.get(index);
    }

    Model getModel() {
        return this.model;
    }

    boolean receivedShapes(Shape shape, InternalSelector predicate) {
        Holder holder = new Holder();
        predicate.push(this, shape, holder);
        return holder.set;
    }

    private static final class Holder
    implements InternalSelector.Receiver {
        boolean set;

        private Holder() {
        }

        @Override
        public InternalSelector.Response apply(Context context, Shape shape) {
            this.set = true;
            return InternalSelector.Response.STOP;
        }
    }
}

