/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.node;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import software.amazon.smithy.model.SourceLocation;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.NodeType;
import software.amazon.smithy.model.node.NodeVisitor;

public final class NumberNode
extends Node {
    private final BigDecimal value;
    private final Number originalValue;
    private final String stringCache;
    private boolean isNaN;
    private boolean isPositiveInfinity;
    private boolean isNegativeInfinity;

    public NumberNode(Number value, SourceLocation sourceLocation) {
        super(sourceLocation);
        this.originalValue = value;
        this.stringCache = value.toString();
        this.value = this.toBigDecimal(this.originalValue);
    }

    private BigDecimal toBigDecimal(Number value) {
        if (value instanceof BigDecimal) {
            return (BigDecimal)value;
        }
        if (value instanceof Integer || value instanceof Long || value instanceof Short || value instanceof Byte) {
            return BigDecimal.valueOf(value.longValue());
        }
        if (value instanceof Float || value instanceof Double) {
            double d = value.doubleValue();
            if (Double.isNaN(d)) {
                this.isNaN = true;
                return null;
            }
            if (Double.isInfinite(d)) {
                if (this.stringCache.startsWith("-")) {
                    this.isNegativeInfinity = true;
                } else {
                    this.isPositiveInfinity = true;
                }
                return null;
            }
            return BigDecimal.valueOf(d);
        }
        if (value instanceof BigInteger) {
            return new BigDecimal((BigInteger)value);
        }
        return new BigDecimal(this.stringCache);
    }

    public Number getValue() {
        return this.originalValue;
    }

    public Optional<BigDecimal> asBigDecimal() {
        return Optional.ofNullable(this.value);
    }

    @Deprecated
    public boolean isNaturalNumber() {
        return !this.isFloatingPointNumber();
    }

    public boolean isNegative() {
        return this.isNegativeInfinity || this.value != null && this.value.compareTo(BigDecimal.ZERO) < 0;
    }

    public boolean isFloatingPointNumber() {
        return this.value == null || this.value.scale() > 0 || this.toString().contains(".");
    }

    public boolean isNaN() {
        return this.isNaN;
    }

    public boolean isInfinite() {
        return this.isPositiveInfinity || this.isNegativeInfinity;
    }

    @Override
    public NodeType getType() {
        return NodeType.NUMBER;
    }

    @Override
    public <R> R accept(NodeVisitor<R> visitor) {
        return visitor.numberNode(this);
    }

    @Override
    public NumberNode expectNumberNode(String errorMessage) {
        return this;
    }

    @Override
    public NumberNode expectNumberNode(Supplier<String> errorMessage) {
        return this;
    }

    @Override
    public Optional<NumberNode> asNumberNode() {
        return Optional.of(this);
    }

    public boolean isZero() {
        return this.value != null && this.value.compareTo(BigDecimal.ZERO) == 0;
    }

    public boolean equals(Object other) {
        if (!(other instanceof NumberNode)) {
            return false;
        }
        if (other == this) {
            return true;
        }
        NumberNode o = (NumberNode)other;
        return this.isNaN == o.isNaN && this.isPositiveInfinity == o.isPositiveInfinity && this.isNegativeInfinity == o.isNegativeInfinity && Objects.equals(this.value, o.value);
    }

    public int hashCode() {
        return this.getType().hashCode() * 7 + this.stringCache.hashCode();
    }

    public String toString() {
        return this.stringCache;
    }
}

