/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.loader;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.NoSuchElementException;
import software.amazon.smithy.model.SourceLocation;
import software.amazon.smithy.model.loader.IdlStringLexer;
import software.amazon.smithy.model.loader.IdlToken;
import software.amazon.smithy.model.loader.IdlTokenizer;
import software.amazon.smithy.model.loader.ModelSyntaxException;
import software.amazon.smithy.model.loader.ParserUtils;
import software.amazon.smithy.utils.SimpleParser;

class DefaultTokenizer
implements IdlTokenizer {
    private final String filename;
    private final SimpleParser parser;
    private IdlToken currentTokenType;
    private int currentTokenStart = -1;
    private int currentTokenEnd = -1;
    private int currentTokenLine = -1;
    private int currentTokenColumn = -1;
    private Number currentTokenNumber;
    private CharSequence currentTokenStringSlice;
    private String currentTokenError;

    DefaultTokenizer(String filename, CharSequence model) {
        this.filename = filename;
        this.parser = new SimpleParser(model, 64);
    }

    @Override
    public final String getSourceFilename() {
        return this.filename;
    }

    @Override
    public final CharSequence getModel() {
        return this.parser.input();
    }

    @Override
    public final int getPosition() {
        return this.parser.position();
    }

    @Override
    public final int getLine() {
        return this.parser.line();
    }

    @Override
    public final int getColumn() {
        return this.parser.column();
    }

    @Override
    public final IdlToken getCurrentToken() {
        if (this.currentTokenType == null) {
            this.next();
        }
        return this.currentTokenType;
    }

    @Override
    public final int getCurrentTokenLine() {
        this.getCurrentToken();
        return this.currentTokenLine;
    }

    @Override
    public final int getCurrentTokenColumn() {
        this.getCurrentToken();
        return this.currentTokenColumn;
    }

    @Override
    public final int getCurrentTokenStart() {
        this.getCurrentToken();
        return this.currentTokenStart;
    }

    @Override
    public final int getCurrentTokenEnd() {
        return this.currentTokenEnd;
    }

    @Override
    public final CharSequence getCurrentTokenStringSlice() {
        this.getCurrentToken();
        if (this.currentTokenStringSlice != null) {
            return this.currentTokenStringSlice;
        }
        if (this.currentTokenType == IdlToken.IDENTIFIER) {
            return this.getCurrentTokenLexeme();
        }
        throw this.syntax("The current token must be string or identifier but found: " + this.currentTokenType.getDebug(this.getCurrentTokenLexeme()), this.getCurrentTokenLocation());
    }

    @Override
    public final Number getCurrentTokenNumberValue() {
        this.getCurrentToken();
        if (this.currentTokenNumber == null) {
            throw this.syntax("The current token must be number but found: " + this.currentTokenType.getDebug(this.getCurrentTokenLexeme()), this.getCurrentTokenLocation());
        }
        return this.currentTokenNumber;
    }

    @Override
    public final String getCurrentTokenError() {
        this.getCurrentToken();
        if (this.currentTokenType != IdlToken.ERROR) {
            throw this.syntax("The current token must be an error but found: " + this.currentTokenType.getDebug(this.getCurrentTokenLexeme()), this.getCurrentTokenLocation());
        }
        return this.currentTokenError == null ? "" : this.currentTokenError;
    }

    @Override
    public final boolean hasNext() {
        return this.currentTokenType != IdlToken.EOF;
    }

    @Override
    public IdlToken next() {
        this.currentTokenStringSlice = null;
        this.currentTokenNumber = null;
        this.currentTokenColumn = this.parser.column();
        this.currentTokenLine = this.parser.line();
        this.currentTokenEnd = this.currentTokenStart = this.parser.position();
        char c = this.parser.peek();
        switch (c) {
            case '\u0000': {
                if (this.currentTokenType == IdlToken.EOF) {
                    throw new NoSuchElementException("Expected another token but reached EOF");
                }
                this.currentTokenEnd = this.parser.position();
                this.currentTokenType = IdlToken.EOF;
                return this.currentTokenType;
            }
            case '\t': 
            case ' ': {
                return this.tokenizeSpace();
            }
            case '\n': 
            case '\r': {
                return this.tokenizeNewline();
            }
            case ',': {
                return this.singleCharToken(IdlToken.COMMA);
            }
            case '@': {
                return this.singleCharToken(IdlToken.AT);
            }
            case '$': {
                return this.singleCharToken(IdlToken.DOLLAR);
            }
            case '.': {
                return this.singleCharToken(IdlToken.DOT);
            }
            case '{': {
                return this.singleCharToken(IdlToken.LBRACE);
            }
            case '}': {
                return this.singleCharToken(IdlToken.RBRACE);
            }
            case '[': {
                return this.singleCharToken(IdlToken.LBRACKET);
            }
            case ']': {
                return this.singleCharToken(IdlToken.RBRACKET);
            }
            case '(': {
                return this.singleCharToken(IdlToken.LPAREN);
            }
            case ')': {
                return this.singleCharToken(IdlToken.RPAREN);
            }
            case '#': {
                return this.singleCharToken(IdlToken.POUND);
            }
            case '=': {
                return this.singleCharToken(IdlToken.EQUAL);
            }
            case ':': {
                return this.parseColon();
            }
            case '\"': {
                return this.parseString();
            }
            case '/': {
                return this.parseComment();
            }
            case '-': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                return this.parseNumber();
            }
            case 'A': 
            case 'B': 
            case 'C': 
            case 'D': 
            case 'E': 
            case 'F': 
            case 'G': 
            case 'H': 
            case 'I': 
            case 'J': 
            case 'K': 
            case 'L': 
            case 'M': 
            case 'N': 
            case 'O': 
            case 'P': 
            case 'Q': 
            case 'R': 
            case 'S': 
            case 'T': 
            case 'U': 
            case 'V': 
            case 'W': 
            case 'X': 
            case 'Y': 
            case 'Z': 
            case '_': 
            case 'a': 
            case 'b': 
            case 'c': 
            case 'd': 
            case 'e': 
            case 'f': 
            case 'g': 
            case 'h': 
            case 'i': 
            case 'j': 
            case 'k': 
            case 'l': 
            case 'm': 
            case 'n': 
            case 'o': 
            case 'p': 
            case 'q': 
            case 'r': 
            case 's': 
            case 't': 
            case 'u': 
            case 'v': 
            case 'w': 
            case 'x': 
            case 'y': 
            case 'z': {
                return this.parseIdentifier();
            }
        }
        this.currentTokenError = "Unexpected character: '" + (char)c + '\'';
        return this.singleCharToken(IdlToken.ERROR);
    }

    private ModelSyntaxException syntax(String message, SourceLocation location) {
        return new ModelSyntaxException("Syntax error at line " + location.getLine() + ", column " + location.getColumn() + ": " + message, location);
    }

    private IdlToken singleCharToken(IdlToken type) {
        this.parser.skip();
        this.currentTokenEnd = this.parser.position();
        this.currentTokenType = type;
        return this.currentTokenType;
    }

    private IdlToken tokenizeNewline() {
        this.parser.skip();
        this.currentTokenEnd = this.parser.position();
        this.currentTokenType = IdlToken.NEWLINE;
        return this.currentTokenType;
    }

    private IdlToken tokenizeSpace() {
        this.parser.consumeWhile(c -> c == 32 || c == 9);
        this.currentTokenEnd = this.parser.position();
        this.currentTokenType = IdlToken.SPACE;
        return this.currentTokenType;
    }

    private IdlToken parseColon() {
        this.parser.skip();
        if (this.parser.peek() == '=') {
            this.parser.skip();
            this.currentTokenType = IdlToken.WALRUS;
        } else {
            this.currentTokenType = IdlToken.COLON;
        }
        this.currentTokenEnd = this.parser.position();
        return this.currentTokenType;
    }

    private IdlToken parseComment() {
        this.parser.expect('/');
        if (this.parser.peek() != '/') {
            this.currentTokenError = "Expected a '/' to follow '/' to form a comment.";
            return this.singleCharToken(IdlToken.ERROR);
        }
        this.parser.skip();
        IdlToken type = IdlToken.COMMENT;
        if (this.parser.peek() == '/') {
            this.parser.skip();
            type = IdlToken.DOC_COMMENT;
        }
        this.parser.consumeRemainingCharactersOnLine();
        if (this.parser.expect(new char[]{'\r', '\n', '\u0000'}) == '\r' && this.parser.peek() == '\n') {
            this.parser.skip();
        }
        this.currentTokenEnd = this.parser.position();
        this.currentTokenType = type;
        return this.currentTokenType;
    }

    private IdlToken parseNumber() {
        try {
            String lexeme = ParserUtils.parseNumber(this.parser);
            if (lexeme.contains("e") || lexeme.contains("E") || lexeme.contains(".")) {
                double value = Double.parseDouble(lexeme);
                this.currentTokenNumber = Double.isFinite(value) ? Double.valueOf(value) : new BigDecimal(lexeme);
            } else {
                try {
                    this.currentTokenNumber = Long.parseLong(lexeme);
                }
                catch (NumberFormatException e) {
                    this.currentTokenNumber = new BigInteger(lexeme);
                }
            }
            this.currentTokenEnd = this.parser.position();
            this.currentTokenType = IdlToken.NUMBER;
            return this.currentTokenType;
        }
        catch (RuntimeException e) {
            this.currentTokenEnd = this.parser.position();
            this.currentTokenError = e.getMessage().startsWith("Syntax error") ? e.getMessage().substring(e.getMessage().indexOf(58) + 1).trim() : e.getMessage();
            this.currentTokenType = IdlToken.ERROR;
            return this.currentTokenType;
        }
    }

    private IdlToken parseIdentifier() {
        try {
            ParserUtils.consumeIdentifier(this.parser);
            this.currentTokenType = IdlToken.IDENTIFIER;
        }
        catch (RuntimeException e) {
            this.currentTokenType = IdlToken.ERROR;
            this.currentTokenError = e.getMessage();
        }
        this.currentTokenEnd = this.parser.position();
        return this.currentTokenType;
    }

    private IdlToken parseString() {
        this.parser.skip();
        if (this.parser.peek() == '\"') {
            this.parser.skip();
            if (this.parser.peek() == '\"') {
                this.parser.skip();
                return this.parseTextBlock();
            }
            this.currentTokenEnd = this.parser.position();
            this.currentTokenStringSlice = "";
            this.currentTokenType = IdlToken.STRING;
            return this.currentTokenType;
        }
        try {
            this.currentTokenStringSlice = this.parseQuotedTextAndTextBlock(false);
            this.currentTokenEnd = this.parser.position();
            this.currentTokenType = IdlToken.STRING;
            return this.currentTokenType;
        }
        catch (RuntimeException e) {
            this.currentTokenEnd = this.parser.position();
            this.currentTokenError = "Error parsing quoted string: " + e.getMessage();
            this.currentTokenType = IdlToken.ERROR;
            return this.currentTokenType;
        }
    }

    private IdlToken parseTextBlock() {
        try {
            this.currentTokenStringSlice = this.parseQuotedTextAndTextBlock(true);
            this.currentTokenEnd = this.parser.position();
            this.currentTokenType = IdlToken.TEXT_BLOCK;
            return this.currentTokenType;
        }
        catch (RuntimeException e) {
            this.currentTokenEnd = this.parser.position();
            this.currentTokenError = "Error parsing text block: " + e.getMessage();
            this.currentTokenType = IdlToken.ERROR;
            return this.currentTokenType;
        }
    }

    private CharSequence parseQuotedTextAndTextBlock(boolean triple) {
        char next;
        int start = this.parser.position();
        while (!this.parser.eof() && ((next = this.parser.peek()) != '\"' || triple && (this.parser.peek(1) != '\"' || this.parser.peek(2) != '\"'))) {
            this.parser.skip();
            if (next != '\\') continue;
            this.parser.skip();
        }
        CharSequence result = this.parser.borrowSliceFrom(start);
        this.parser.expect('\"');
        if (triple) {
            this.parser.expect('\"');
            this.parser.expect('\"');
        }
        return IdlStringLexer.scanStringContents(result, triple);
    }
}

