/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.validation.node;

import java.util.function.BiConsumer;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.node.StringNode;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.StringShape;
import software.amazon.smithy.model.traits.PatternTrait;
import software.amazon.smithy.model.validation.node.MemberAndShapeTraitPlugin;

final class PatternTraitPlugin
extends MemberAndShapeTraitPlugin<StringShape, StringNode, PatternTrait> {
    PatternTraitPlugin() {
        super(StringShape.class, StringNode.class, PatternTrait.class);
    }

    @Override
    protected void check(Shape shape, PatternTrait trait, StringNode node, Model model, BiConsumer<FromSourceLocation, String> emitter) {
        if (!trait.getPattern().matcher(node.getValue()).find()) {
            emitter.accept(node, String.format("String value provided for `%s` must match regular expression: %s", shape.getId(), trait.getPattern().pattern()));
        }
    }
}

