/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.validation;

import java.util.function.Function;
import java.util.function.Supplier;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.validation.Validator;

public interface ValidatorService {
    public String getName();

    public Validator createValidator(ObjectNode var1);

    public static String determineValidatorName(Class<?> clazz) {
        String name = clazz.getSimpleName();
        return name.endsWith("Validator") ? name.substring(0, name.length() - "Validator".length()) : name;
    }

    public static abstract class Provider
    implements ValidatorService {
        private String name;
        private Function<ObjectNode, ? extends Validator> provider;

        public Provider(String name, Function<ObjectNode, ? extends Validator> provider) {
            this.name = name;
            this.provider = provider;
        }

        public <T extends Validator> Provider(Class<T> klass, Function<ObjectNode, T> provider) {
            this(ValidatorService.determineValidatorName(klass), provider);
        }

        public <T extends Validator> Provider(Class<T> klass, Supplier<T> supplier) {
            this(ValidatorService.determineValidatorName(klass), (ObjectNode c) -> (Validator)supplier.get());
        }

        @Override
        public final String getName() {
            return this.name;
        }

        @Override
        public final Validator createValidator(ObjectNode configuration) {
            return this.provider.apply(configuration);
        }
    }
}

