/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.traits;

import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.utils.SmithyBuilder;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class EffectiveTraitQuery
implements ToSmithyBuilder<EffectiveTraitQuery> {
    private final Model model;
    private final Class<? extends Trait> traitClass;
    private final boolean inheritFromContainer;

    private EffectiveTraitQuery(Builder builder) {
        this.model = (Model)SmithyBuilder.requiredState((String)"model", (Object)builder.model);
        this.traitClass = (Class)SmithyBuilder.requiredState((String)"traitClass", (Object)builder.traitClass);
        this.inheritFromContainer = builder.inheritFromContainer;
    }

    public boolean isTraitApplied(ToShapeId shapeId) {
        Shape shape = this.model.getShape(shapeId.toShapeId()).orElse(null);
        if (shape == null) {
            return false;
        }
        if (shape.getMemberTrait(this.model, this.traitClass).isPresent()) {
            return true;
        }
        if (!this.inheritFromContainer || !shape.asMemberShape().isPresent()) {
            return false;
        }
        MemberShape memberShape = shape.asMemberShape().get();
        Shape parent = this.model.getShape(memberShape.getContainer()).orElse(null);
        return parent != null && parent.hasTrait(this.traitClass);
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return EffectiveTraitQuery.builder().model(this.model).traitClass(this.traitClass).inheritFromContainer(this.inheritFromContainer);
    }

    public static final class Builder
    implements SmithyBuilder<EffectiveTraitQuery> {
        private Model model;
        private Class<? extends Trait> traitClass;
        private boolean inheritFromContainer;

        public EffectiveTraitQuery build() {
            return new EffectiveTraitQuery(this);
        }

        public Builder model(Model model) {
            this.model = model;
            return this;
        }

        public Builder traitClass(Class<? extends Trait> traitClass) {
            this.traitClass = traitClass;
            return this;
        }

        public Builder inheritFromContainer(boolean inheritFromContainer) {
            this.inheritFromContainer = inheritFromContainer;
            return this;
        }
    }
}

