/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.validation.validators;

import java.util.ArrayList;
import java.util.List;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.loader.Prelude;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.model.validation.NodeValidationVisitor;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.model.validation.Validator;
import software.amazon.smithy.utils.ListUtils;

public final class TraitValueValidator
implements Validator {
    public static final String VALIDATE_PRELUDE = "__validatePrelude__";
    private static final String NAME = "TraitValue";

    @Override
    public List<ValidationEvent> validate(Model model) {
        NodeValidationVisitor validator = NodeValidationVisitor.builder().eventId(NAME).model(model).value(Node.nullNode()).build();
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        boolean validatePrelude = model.getMetadataProperty(VALIDATE_PRELUDE).isPresent();
        for (Shape shape : model.toSet()) {
            for (Trait trait : shape.getAllTraits().values()) {
                events.addAll(this.validateTrait(model, validator, shape, trait, validatePrelude));
            }
        }
        return events;
    }

    private List<ValidationEvent> validateTrait(Model model, NodeValidationVisitor validator, Shape targetShape, Trait trait, boolean validatePrelude) {
        ShapeId shape = trait.toShapeId();
        if (!model.getShape(shape).isPresent()) {
            return ListUtils.of();
        }
        if (!validatePrelude && Prelude.isPreludeShape(targetShape)) {
            return ListUtils.of();
        }
        validator.setValue(trait.toNode());
        validator.setEventShapeId(targetShape.getId());
        validator.setStartingContext("Error validating trait `" + Trait.getIdiomaticTraitName(trait) + "`");
        return model.getShape(shape).get().accept(validator);
    }
}

