/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.validation.validators;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.IdentifierBindingIndex;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.ResourceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.traits.ResourceIdentifierTrait;
import software.amazon.smithy.model.traits.StringTrait;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.model.validation.ValidationUtils;
import software.amazon.smithy.utils.FunctionalUtils;
import software.amazon.smithy.utils.OptionalUtils;
import software.amazon.smithy.utils.Pair;

public final class ResourceIdentifierBindingValidator
extends AbstractValidator {
    @Override
    public List<ValidationEvent> validate(Model model) {
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        this.validateResourceIdentifierTraits(model, events);
        this.validateOperationBindings(model, events);
        return events;
    }

    private void validateResourceIdentifierTraits(Model model, List<ValidationEvent> events) {
        for (ShapeId container : this.findStructuresWithResourceIdentifierTraits(model)) {
            if (!model.getShape(container).isPresent()) continue;
            Shape structure = model.expectShape(container);
            Map<String, Set<String>> bindings = this.computePotentialStructureBindings(structure);
            for (Map.Entry<String, Set<String>> entry : bindings.entrySet()) {
                if (entry.getValue().size() <= 1 || !entry.getValue().contains(entry.getKey())) continue;
                Set<String> explicitBindings = entry.getValue();
                explicitBindings.remove(entry.getKey());
                events.add(this.warning(structure, String.format("Implicit resource identifier for '%s' is overridden by `resourceIdentifier` trait on members: '%s'", entry.getKey(), String.join((CharSequence)"', '", explicitBindings))));
            }
            this.validateResourceIdentifierTraitConflicts(structure, events);
        }
    }

    private Set<ShapeId> findStructuresWithResourceIdentifierTraits(Model model) {
        HashSet<ShapeId> containers = new HashSet<ShapeId>();
        for (MemberShape member : model.getMemberShapesWithTrait(ResourceIdentifierTrait.class)) {
            containers.add(member.getContainer());
        }
        return containers;
    }

    private Map<String, Set<String>> computePotentialStructureBindings(Shape structure) {
        HashMap<String, Set<String>> bindings = new HashMap<String, Set<String>>();
        for (MemberShape member : structure.members()) {
            String bindingName = member.getTrait(ResourceIdentifierTrait.class).map(StringTrait::getValue).orElseGet(member::getMemberName);
            bindings.computeIfAbsent(bindingName, k -> new HashSet()).add(member.getMemberName());
        }
        return bindings;
    }

    private void validateResourceIdentifierTraitConflicts(Shape structure, List<ValidationEvent> events) {
        HashMap<String, Set> explicitBindings = new HashMap<String, Set>();
        for (MemberShape memberShape : structure.members()) {
            if (!memberShape.hasTrait(ResourceIdentifierTrait.class)) continue;
            explicitBindings.computeIfAbsent(memberShape.expectTrait(ResourceIdentifierTrait.class).getValue(), k -> new HashSet()).add(memberShape.getMemberName());
        }
        for (Map.Entry entry : explicitBindings.entrySet()) {
            if (((Set)entry.getValue()).size() <= 1) continue;
            events.add(this.error(structure, String.format("Conflicting resource identifier member bindings found for identifier '%s' between members: '%s'", entry.getKey(), String.join((CharSequence)"', '", (Iterable)entry.getValue()))));
        }
    }

    private void validateOperationBindings(Model model, List<ValidationEvent> events) {
        IdentifierBindingIndex bindingIndex = IdentifierBindingIndex.of(model);
        Stream.of(model.shapes(ResourceShape.class).flatMap(resource -> this.validateResource(model, (ResourceShape)resource, bindingIndex)), model.shapes(ResourceShape.class).flatMap(resource -> this.validateCollectionBindings(model, (ResourceShape)resource, bindingIndex)), model.shapes(ResourceShape.class).flatMap(resource -> this.validateInstanceBindings(model, (ResourceShape)resource, bindingIndex))).flatMap(Function.identity()).forEach(events::add);
    }

    private Stream<ValidationEvent> validateResource(Model model, ResourceShape parent, IdentifierBindingIndex bindingIndex) {
        return parent.getResources().stream().flatMap(childId -> OptionalUtils.stream(model.getShape((ShapeId)childId).flatMap(Shape::asResourceShape))).flatMap(child -> child.getAllOperations().stream().flatMap(id -> OptionalUtils.stream(model.getShape((ShapeId)id).flatMap(Shape::asOperationShape))).map(operation -> Pair.of((Object)child, (Object)operation))).flatMap(pair -> OptionalUtils.stream(this.validateOperation(parent, (ResourceShape)pair.getLeft(), (OperationShape)pair.getRight(), bindingIndex)));
    }

    private Optional<ValidationEvent> validateOperation(ResourceShape parent, ResourceShape child, OperationShape operation, IdentifierBindingIndex bindingIndex) {
        if (bindingIndex.getOperationBindingType(child, operation) != IdentifierBindingIndex.BindingType.NONE) {
            Set<String> bindings = bindingIndex.getOperationInputBindings(child, operation).keySet();
            Set missing = parent.getIdentifiers().keySet().stream().filter(FunctionalUtils.not(bindings::contains)).collect(Collectors.toSet());
            if (!missing.isEmpty()) {
                return Optional.of(this.error(operation, String.format("This operation is bound to the `%s` resource, which is a child of the `%s` resource, and it is missing the following resource identifier bindings of `%s`: [%s]", child.getId(), parent.getId(), parent.getId(), ValidationUtils.tickedList(missing))));
            }
        }
        return Optional.empty();
    }

    private Stream<ValidationEvent> validateCollectionBindings(Model model, ResourceShape resource, IdentifierBindingIndex identifierIndex) {
        return resource.getAllOperations().stream().filter(operation -> identifierIndex.getOperationBindingType(resource, (ToShapeId)operation) == IdentifierBindingIndex.BindingType.COLLECTION).flatMap(id -> OptionalUtils.stream(model.getShape((ShapeId)id).flatMap(Shape::asOperationShape))).filter(operation -> this.hasAllIdentifiersBound(resource, (OperationShape)operation, identifierIndex)).map(operation -> this.error((Shape)operation, String.format("This operation is bound as a collection operation on the `%s` resource, but it improperly binds all of the identifiers of the resource to members of the operation input.", resource.getId())));
    }

    private Stream<ValidationEvent> validateInstanceBindings(Model model, ResourceShape resource, IdentifierBindingIndex bindingIndex) {
        return resource.getAllOperations().stream().filter(operation -> bindingIndex.getOperationBindingType(resource, (ToShapeId)operation) == IdentifierBindingIndex.BindingType.INSTANCE).flatMap(id -> OptionalUtils.stream(model.getShape((ShapeId)id).flatMap(Shape::asOperationShape))).filter(operation -> !this.hasAllIdentifiersBound(resource, (OperationShape)operation, bindingIndex)).map(operation -> {
            String expectedIdentifiers = this.createBindingMessage(resource.getIdentifiers());
            String boundIds = this.createBindingMessage(bindingIndex.getOperationInputBindings(resource, (ToShapeId)operation));
            return this.error((Shape)operation, String.format("This operation does not form a valid instance operation when bound to resource `%s`. All of the identifiers of the resource were not implicitly or explicitly bound to the input of the operation. Expected the following identifier bindings: [%s]. Found the following identifier bindings: [%s]", resource.getId(), expectedIdentifiers, boundIds));
        });
    }

    private boolean hasAllIdentifiersBound(ResourceShape resource, OperationShape operation, IdentifierBindingIndex bindingIndex) {
        return bindingIndex.getOperationInputBindings(resource, operation).keySet().containsAll(resource.getIdentifiers().keySet());
    }

    private String createBindingMessage(Map<String, ?> bindings) {
        return bindings.entrySet().stream().map(entry -> String.format("required member named `%s` that targets `%s`", entry.getKey(), entry.getValue().toString())).sorted().collect(Collectors.joining(", "));
    }
}

