/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.transform.plugins;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.traits.ReferencesTrait;
import software.amazon.smithy.model.transform.ModelTransformer;
import software.amazon.smithy.model.transform.ModelTransformerPlugin;

public final class CleanResourceReferences
implements ModelTransformerPlugin {
    @Override
    public Model onRemove(ModelTransformer transformer, Collection<Shape> shapes, Model model) {
        HashSet toReplace = new HashSet();
        shapes.forEach(shape -> toReplace.addAll(this.getAffectedStructures(model, (Shape)shape)));
        return transformer.replaceShapes(model, toReplace);
    }

    private Set<Shape> getAffectedStructures(Model model, Shape resource) {
        HashSet<Shape> result = new HashSet<Shape>();
        for (StructureShape struct : model.getStructureShapesWithTrait(ReferencesTrait.class)) {
            ReferencesTrait trait = struct.expectTrait(ReferencesTrait.class);
            List<ReferencesTrait.Reference> references = trait.getResourceReferences(resource.getId());
            if (references.isEmpty()) continue;
            ReferencesTrait.Builder traitBuilder = trait.toBuilder();
            traitBuilder.clearReferences();
            for (ReferencesTrait.Reference ref : trait.getReferences()) {
                if (references.contains(ref)) continue;
                traitBuilder.addReference(ref);
            }
            result.add(((StructureShape.Builder)struct.toBuilder().addTrait(traitBuilder.build())).build());
        }
        return result;
    }
}

