/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.loader;

import software.amazon.smithy.model.loader.IdlToken;
import software.amazon.smithy.model.loader.IdlTokenizer;

final class IdlShapeIdParser {
    private IdlShapeIdParser() {
    }

    static CharSequence expectAndSkipShapeIdNamespace(IdlTokenizer tokenizer) {
        int startPosition = tokenizer.getCurrentTokenStart();
        int endOffset = IdlShapeIdParser.skipShapeIdNamespace(tokenizer);
        return IdlShapeIdParser.sliceFrom(tokenizer, startPosition, endOffset);
    }

    static CharSequence expectAndSkipAbsoluteShapeId(IdlTokenizer tokenizer) {
        int startPosition = tokenizer.getCurrentTokenStart();
        int endOffset = IdlShapeIdParser.skipAbsoluteShapeId(tokenizer);
        return IdlShapeIdParser.sliceFrom(tokenizer, startPosition, endOffset);
    }

    static CharSequence expectAndSkipShapeId(IdlTokenizer tokenizer) {
        int startPosition = tokenizer.getCurrentTokenStart();
        int offset = IdlShapeIdParser.skipShapeIdNamespace(tokenizer);
        if (tokenizer.getCurrentToken() != IdlToken.DOLLAR && tokenizer.getCurrentToken() != IdlToken.POUND) {
            return IdlShapeIdParser.sliceFrom(tokenizer, startPosition, offset);
        }
        tokenizer.next();
        offset = IdlShapeIdParser.skipRelativeRootShapeId(tokenizer);
        return IdlShapeIdParser.sliceFrom(tokenizer, startPosition, offset);
    }

    private static CharSequence sliceFrom(IdlTokenizer tokenizer, int startPosition, int endOffset) {
        return tokenizer.getInput(startPosition, tokenizer.getPosition() - endOffset);
    }

    private static int skipShapeIdNamespace(IdlTokenizer tokenizer) {
        tokenizer.expect(IdlToken.IDENTIFIER);
        tokenizer.next();
        int endOffset = tokenizer.getCurrentTokenSpan();
        while (tokenizer.getCurrentToken() == IdlToken.DOT) {
            tokenizer.next();
            tokenizer.expect(IdlToken.IDENTIFIER);
            tokenizer.next();
            endOffset = tokenizer.getCurrentTokenSpan();
        }
        return endOffset;
    }

    private static int skipAbsoluteShapeId(IdlTokenizer tokenizer) {
        IdlShapeIdParser.skipShapeIdNamespace(tokenizer);
        tokenizer.expect(IdlToken.POUND);
        tokenizer.next();
        return IdlShapeIdParser.skipRelativeRootShapeId(tokenizer);
    }

    private static int skipRelativeRootShapeId(IdlTokenizer tokenizer) {
        tokenizer.expect(IdlToken.IDENTIFIER);
        tokenizer.next();
        int endOffset = tokenizer.getCurrentTokenSpan();
        if (tokenizer.getCurrentToken() == IdlToken.DOLLAR) {
            tokenizer.next();
            tokenizer.expect(IdlToken.IDENTIFIER);
            tokenizer.next();
            endOffset = tokenizer.getCurrentTokenSpan();
        }
        return endOffset;
    }
}

