/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.validation.validators;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.traits.HttpQueryTrait;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.model.validation.ValidationUtils;

public final class HttpQueryTraitValidator
extends AbstractValidator {
    @Override
    public List<ValidationEvent> validate(Model model) {
        if (!model.isTraitApplied(HttpQueryTrait.class)) {
            return Collections.emptyList();
        }
        return this.validateBindings(this.getQueryBindings(model));
    }

    private Map<StructureShape, Map<String, Set<String>>> getQueryBindings(Model model) {
        HashMap<StructureShape, Map<String, Set<String>>> queryBindings = new HashMap<StructureShape, Map<String, Set<String>>>();
        for (Shape shape : model.getShapesWithTrait(HttpQueryTrait.class)) {
            shape.asMemberShape().ifPresent(member -> model.getShape(member.getContainer()).flatMap(Shape::asStructureShape).ifPresent(structure -> {
                HttpQueryTrait trait = shape.expectTrait(HttpQueryTrait.class);
                queryBindings.computeIfAbsent((StructureShape)structure, s -> new HashMap()).computeIfAbsent(trait.getValue(), v -> new HashSet()).add(member.getMemberName());
            }));
        }
        return queryBindings;
    }

    private List<ValidationEvent> validateBindings(Map<StructureShape, Map<String, Set<String>>> queryBindings) {
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        for (Map.Entry<StructureShape, Map<String, Set<String>>> entry : queryBindings.entrySet()) {
            for (Map.Entry<String, Set<String>> paramsToMembers : entry.getValue().entrySet()) {
                if (paramsToMembers.getValue().size() <= 1) continue;
                events.add(this.error(entry.getKey(), String.format("`httpQuery` parameter name binding conflicts found for the `%s` parameter in the following structure members: %s", paramsToMembers.getKey(), ValidationUtils.tickedList((Collection)paramsToMembers.getValue()))));
            }
        }
        return events;
    }
}

