/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.traits;

import java.util.Objects;
import java.util.Optional;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.StringNode;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.traits.AbstractTrait;
import software.amazon.smithy.model.traits.AbstractTraitBuilder;
import software.amazon.smithy.model.traits.TraitService;
import software.amazon.smithy.utils.MapUtils;
import software.amazon.smithy.utils.SmithyBuilder;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class XmlNamespaceTrait
extends AbstractTrait
implements ToSmithyBuilder<XmlNamespaceTrait> {
    public static final ShapeId ID = ShapeId.from("smithy.api#xmlNamespace");
    private static final String PREFIX = "prefix";
    private static final String URI = "uri";
    private final String prefix;
    private final String uri;

    private XmlNamespaceTrait(Builder builder) {
        super(ID, builder.getSourceLocation());
        this.uri = (String)SmithyBuilder.requiredState((String)URI, (Object)builder.uri);
        this.prefix = builder.prefix;
    }

    public String getUri() {
        return this.uri;
    }

    public Optional<String> getPrefix() {
        return Optional.ofNullable(this.prefix);
    }

    @Override
    protected Node createNode() {
        return new ObjectNode(MapUtils.of(), this.getSourceLocation()).withMember(URI, Node.from(this.uri)).withOptionalMember(PREFIX, this.getPrefix().map(Node::from));
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return ((Builder)XmlNamespaceTrait.builder().sourceLocation(this.getSourceLocation())).uri(this.uri).prefix(this.prefix);
    }

    public static final class Provider
    implements TraitService {
        @Override
        public ShapeId getShapeId() {
            return ID;
        }

        @Override
        public XmlNamespaceTrait createTrait(ShapeId target, Node value) {
            Builder builder = (Builder)XmlNamespaceTrait.builder().sourceLocation(value);
            ObjectNode node = value.expectObjectNode();
            builder.uri(node.expectStringMember(XmlNamespaceTrait.URI).getValue());
            node.getStringMember(XmlNamespaceTrait.PREFIX).map(StringNode::getValue).ifPresent(builder::prefix);
            return builder.build();
        }
    }

    public static final class Builder
    extends AbstractTraitBuilder<XmlNamespaceTrait, Builder> {
        private String uri;
        private String prefix;

        private Builder() {
        }

        public Builder uri(String uri) {
            this.uri = Objects.requireNonNull(uri);
            return this;
        }

        public Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public XmlNamespaceTrait build() {
            return new XmlNamespaceTrait(this);
        }
    }
}

