/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.validation.validators;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.traits.HttpHeaderTrait;
import software.amazon.smithy.model.traits.HttpPrefixHeadersTrait;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;

public final class HttpPrefixHeadersTraitValidator
extends AbstractValidator {
    @Override
    public List<ValidationEvent> validate(Model model) {
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        for (MemberShape member : model.getMemberShapesWithTrait(HttpPrefixHeadersTrait.class)) {
            model.getShape(member.getContainer()).flatMap(Shape::asStructureShape).ifPresent(structure -> events.addAll(this.validateMember((StructureShape)structure, member, member.expectTrait(HttpPrefixHeadersTrait.class))));
        }
        return events;
    }

    private List<ValidationEvent> validateMember(StructureShape structure, MemberShape member, HttpPrefixHeadersTrait prefixTrait) {
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        String prefix = prefixTrait.getValue().toLowerCase(Locale.ENGLISH);
        for (MemberShape otherMember : structure.getAllMembers().values()) {
            otherMember.getTrait(HttpHeaderTrait.class).ifPresent(httpHeaderTrait -> {
                String lowerCaseHeader = httpHeaderTrait.getValue().toLowerCase(Locale.ENGLISH);
                if (lowerCaseHeader.startsWith(prefix)) {
                    events.add(this.error(otherMember, (FromSourceLocation)httpHeaderTrait, String.format("`httpHeader` binding of `%s` conflicts with the `httpPrefixHeaders` binding of `%s` to `%s`. `httpHeader` bindings must not case-insensitively start with any `httpPrefixHeaders` bindings.", lowerCaseHeader, member.getId(), prefix)));
                }
            });
        }
        return events;
    }
}

