/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.transform;

import java.util.List;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.AbstractShapeBuilder;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.model.transform.ModelTransformer;

final class FilterTraits {
    private final BiPredicate<Shape, Trait> predicate;

    FilterTraits(BiPredicate<Shape, Trait> predicate) {
        this.predicate = predicate;
    }

    Model transform(ModelTransformer transformer, Model model) {
        return transformer.mapShapes(model, this::filterTraits);
    }

    private Shape filterTraits(Shape shape) {
        List keepTraits = shape.getAllTraits().values().stream().filter(trait -> this.predicate.test(shape, (Trait)trait)).collect(Collectors.toList());
        return keepTraits.size() == shape.getAllTraits().size() ? shape : (Shape)((AbstractShapeBuilder)((AbstractShapeBuilder)Shape.shapeToBuilder(shape)).clearTraits()).addTraits(keepTraits).build();
    }
}

