/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.transform.plugins;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.AbstractShapeBuilder;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.shapes.UnionShape;
import software.amazon.smithy.model.traits.MixinTrait;
import software.amazon.smithy.model.transform.ModelTransformer;
import software.amazon.smithy.model.transform.ModelTransformerPlugin;
import software.amazon.smithy.utils.SmithyInternalApi;

@SmithyInternalApi
public final class RemoveMixins
implements ModelTransformerPlugin {
    @Override
    public Model onRemove(ModelTransformer transformer, Collection<Shape> shapes, Model model) {
        HashMap mixinShapesToRemove = new HashMap();
        for (Shape removedShape : shapes) {
            if (!removedShape.hasTrait(MixinTrait.class) || removedShape.isMemberShape()) continue;
            Stream.concat(model.shapes(StructureShape.class), model.shapes(UnionShape.class)).forEach(shape -> {
                if (shape.getMixins().contains(removedShape.getId())) {
                    mixinShapesToRemove.computeIfAbsent(shape, s -> new HashSet()).add(removedShape);
                }
            });
        }
        if (mixinShapesToRemove.isEmpty()) {
            return model;
        }
        ArrayList<Shape> toReplace = new ArrayList<Shape>(mixinShapesToRemove.size());
        for (Map.Entry entry : mixinShapesToRemove.entrySet()) {
            Object builder = Shape.shapeToBuilder((Shape)entry.getKey());
            for (Shape mixin : (Set)entry.getValue()) {
                ((AbstractShapeBuilder)builder).removeMixin(mixin);
            }
            toReplace.add((Shape)builder.build());
        }
        return transformer.replaceShapes(model, toReplace);
    }
}

