/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.shapes;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import software.amazon.smithy.model.SourceLocation;
import software.amazon.smithy.model.shapes.AbstractShapeBuilder;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;

public abstract class CollectionShape
extends Shape {
    private final MemberShape member;
    private transient Map<String, MemberShape> memberMap;

    CollectionShape(Builder<?, ?> builder) {
        super(builder, false);
        this.member = this.getRequiredMixinMember(builder, ((Builder)builder).member, "member");
        ShapeId expected = this.getId().withMember("member");
        if (!this.member.getId().equals(expected)) {
            throw new IllegalArgumentException(String.format("Expected member of `%s` to have an ID of `%s` but found `%s`", this.getId(), expected, this.member.getId()));
        }
    }

    public final MemberShape getMember() {
        return this.member;
    }

    @Override
    public final Map<String, MemberShape> getAllMembers() {
        Map<String, MemberShape> members = this.memberMap;
        if (members == null) {
            this.memberMap = members = Collections.singletonMap("member", this.member);
        }
        return members;
    }

    public static abstract class Builder<B extends Builder<B, S>, S extends CollectionShape>
    extends AbstractShapeBuilder<B, S> {
        private MemberShape member;

        @Override
        public B id(ShapeId shapeId) {
            if (this.member != null) {
                this.member(((MemberShape.Builder)this.member.toBuilder().id(shapeId.withMember(this.member.getMemberName()))).build());
            }
            return (B)((Builder)super.id(shapeId));
        }

        public B member(MemberShape member) {
            this.member = Objects.requireNonNull(member);
            return (B)this;
        }

        public B member(ShapeId target) {
            return this.member(target, null);
        }

        public B member(ShapeId target, Consumer<MemberShape.Builder> memberUpdater) {
            if (this.getId() == null) {
                throw new IllegalStateException("An id must be set before setting a member with a target");
            }
            MemberShape.Builder builder = (MemberShape.Builder)MemberShape.builder().target(target).id(this.getId().withMember("member"));
            if (memberUpdater != null) {
                memberUpdater.accept(builder);
            }
            return this.member(builder.build());
        }

        @Override
        public B addMember(MemberShape member) {
            return this.member(member);
        }

        @Override
        public B clearMembers() {
            this.member = null;
            return (B)((Builder)super.clearMembers());
        }

        @Override
        public B flattenMixins() {
            if (this.getMixins().isEmpty()) {
                return (B)this;
            }
            for (Shape mixin : this.getMixins().values()) {
                SourceLocation location = this.getSourceLocation();
                Collection<Object> localTraits = Collections.emptyList();
                MemberShape mixinMember = ((CollectionShape)mixin).getMember();
                MemberShape existing = this.member;
                if (existing != null) {
                    localTraits = existing.getIntroducedTraits().values();
                    location = existing.getSourceLocation();
                }
                this.member = ((MemberShape.Builder)((MemberShape.Builder)((MemberShape.Builder)((MemberShape.Builder)MemberShape.builder().id(this.getId().withMember(mixinMember.getMemberName()))).target(mixinMember.getTarget()).addTraits(mixinMember.getAllTraits().values())).addTraits(localTraits)).source(location)).build();
            }
            return (B)((Builder)super.flattenMixins());
        }
    }
}

