/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.neighbor;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.NeighborProviderIndex;
import software.amazon.smithy.model.loader.Prelude;
import software.amazon.smithy.model.neighbor.Walker;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.traits.TraitDefinition;
import software.amazon.smithy.utils.FunctionalUtils;

public final class UnreferencedShapes {
    private final Predicate<Shape> keepFilter;

    public UnreferencedShapes() {
        this(FunctionalUtils.alwaysTrue());
    }

    public UnreferencedShapes(Predicate<Shape> keepFilter) {
        this.keepFilter = keepFilter;
    }

    public Set<Shape> compute(Model model) {
        Walker shapeWalker = new Walker(NeighborProviderIndex.of(model).getProvider());
        HashSet<Shape> connected = new HashSet<Shape>();
        for (Shape shape : model.getServiceShapes()) {
            connected.addAll(shapeWalker.walkShapes(shape));
        }
        for (Shape shape : model.getShapesWithTrait(TraitDefinition.class)) {
            connected.addAll(shapeWalker.walkShapes(shape));
        }
        HashSet<Shape> result = new HashSet<Shape>();
        for (Shape shape : model.toSet()) {
            if (shape.isMemberShape() || connected.contains(shape) || Prelude.isPreludeShape(shape) || !this.keepFilter.test(shape)) continue;
            result.add(shape);
        }
        return result;
    }
}

