/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.traits;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import software.amazon.smithy.model.node.ArrayNode;
import software.amazon.smithy.model.node.ExpectationNotMetException;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.NodePointer;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.ToNode;
import software.amazon.smithy.model.selector.Selector;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.traits.AbstractTrait;
import software.amazon.smithy.model.traits.AbstractTraitBuilder;
import software.amazon.smithy.model.traits.TraitService;
import software.amazon.smithy.model.validation.Severity;
import software.amazon.smithy.utils.BuilderRef;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class TraitDefinition
extends AbstractTrait
implements ToSmithyBuilder<TraitDefinition> {
    public static final ShapeId ID = ShapeId.from("smithy.api#trait");
    private final Selector selector;
    private final List<ShapeId> conflicts;
    private final StructurallyExclusive structurallyExclusive;
    private final List<BreakingChangeRule> breakingChanges;

    public TraitDefinition(Builder builder) {
        super(ID, builder.sourceLocation);
        this.selector = builder.selector;
        this.conflicts = (List)builder.conflicts.copy();
        this.structurallyExclusive = builder.structurallyExclusive;
        this.breakingChanges = (List)builder.breakingChanges.copy();
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        Builder builder = ((Builder)TraitDefinition.builder().sourceLocation(this.getSourceLocation())).selector(this.selector).structurallyExclusive(this.structurallyExclusive).breakingChanges(this.breakingChanges);
        this.conflicts.forEach(builder::addConflict);
        return builder;
    }

    public Selector getSelector() {
        return this.selector;
    }

    public List<ShapeId> getConflicts() {
        return this.conflicts;
    }

    public Optional<StructurallyExclusive> getStructurallyExclusive() {
        return Optional.ofNullable(this.structurallyExclusive);
    }

    public boolean isStructurallyExclusiveByMember() {
        return this.structurallyExclusive == StructurallyExclusive.MEMBER;
    }

    public boolean isStructurallyExclusiveByTarget() {
        return this.structurallyExclusive == StructurallyExclusive.TARGET;
    }

    public List<BreakingChangeRule> getBreakingChanges() {
        return this.breakingChanges;
    }

    @Override
    protected Node createNode() {
        ObjectNode.Builder builder = Node.objectNodeBuilder().sourceLocation(this.getSourceLocation());
        if (this.selector != Selector.IDENTITY) {
            builder.withMember("selector", this.selector.toString());
        }
        if (!this.conflicts.isEmpty()) {
            builder.withMember("conflicts", (ToNode)this.conflicts.stream().map(ShapeId::toString).map(Node::from).collect(ArrayNode.collect()));
        }
        builder.withOptionalMember("structurallyExclusive", this.getStructurallyExclusive().map(StructurallyExclusive::toNode));
        if (!this.breakingChanges.isEmpty()) {
            ArrayList result = new ArrayList(this.breakingChanges.size());
            this.breakingChanges.forEach(d -> result.add(d.toNode()));
            builder.withMember("breakingChanges", Node.fromNodes(result));
        }
        return builder.build();
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof TraitDefinition)) {
            return false;
        }
        if (other == this) {
            return true;
        }
        TraitDefinition od = (TraitDefinition)other;
        return this.selector.equals(od.selector) && this.conflicts.equals(od.conflicts) && Objects.equals(this.structurallyExclusive, od.structurallyExclusive) && this.breakingChanges.equals(od.breakingChanges);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.toShapeId(), this.selector, this.conflicts, this.structurallyExclusive, this.breakingChanges);
    }

    public static final class Provider
    implements TraitService {
        @Override
        public ShapeId getShapeId() {
            return ID;
        }

        @Override
        public TraitDefinition createTrait(ShapeId target, Node value) {
            ObjectNode members = value.isNullNode() ? Node.objectNode() : value.expectObjectNode();
            Builder builder = (Builder)TraitDefinition.builder().sourceLocation(value);
            members.expectObjectNode().getMember("selector", Selector::fromNode, builder::selector).getMember("structurallyExclusive", StructurallyExclusive::fromNode, builder::structurallyExclusive).getArrayMember("conflicts", nodes -> {
                for (Node element : nodes) {
                    builder.addConflict(element.expectStringNode().getValue());
                }
            }).getArrayMember("breakingChanges", BreakingChangeRule::fromNode, builder::breakingChanges);
            TraitDefinition result = builder.build();
            result.setNodeCache(value);
            return result;
        }
    }

    public static final class Builder
    extends AbstractTraitBuilder<TraitDefinition, Builder> {
        private Selector selector = Selector.IDENTITY;
        private final BuilderRef<List<ShapeId>> conflicts = BuilderRef.forList();
        private StructurallyExclusive structurallyExclusive;
        private final BuilderRef<List<BreakingChangeRule>> breakingChanges = BuilderRef.forList();

        private Builder() {
        }

        public Builder selector(Selector selector) {
            this.selector = selector;
            return this;
        }

        public Builder addConflict(String trait) {
            Objects.requireNonNull(trait);
            return this.addConflict(ShapeId.from(trait));
        }

        public Builder addConflict(ShapeId id) {
            Objects.requireNonNull(id);
            ((List)this.conflicts.get()).add(id);
            return this;
        }

        public Builder removeConflict(ToShapeId id) {
            ((List)this.conflicts.get()).remove(id.toShapeId());
            return this;
        }

        public Builder structurallyExclusive(StructurallyExclusive structurallyExclusive) {
            this.structurallyExclusive = structurallyExclusive;
            return this;
        }

        public Builder breakingChanges(List<BreakingChangeRule> diff) {
            this.clearBreakingChanges();
            diff.forEach(this::addBreakingChange);
            return this;
        }

        public Builder clearBreakingChanges() {
            this.breakingChanges.clear();
            return this;
        }

        public Builder addBreakingChange(BreakingChangeRule rule) {
            ((List)this.breakingChanges.get()).add(Objects.requireNonNull(rule));
            return this;
        }

        public TraitDefinition build() {
            return new TraitDefinition(this);
        }
    }

    public static enum ChangeType implements ToNode
    {
        ADD,
        REMOVE,
        PRESENCE,
        UPDATE,
        ANY;


        public static ChangeType fromNode(Node node) {
            try {
                return ChangeType.valueOf(node.expectStringNode().getValue().toUpperCase(Locale.ENGLISH));
            }
            catch (RuntimeException e) {
                String message = "Expected a string containing a valid trait diff type: " + e.getMessage();
                throw new ExpectationNotMetException(message, node);
            }
        }

        @Override
        public Node toNode() {
            return Node.from(this.toString());
        }

        public String toString() {
            return super.toString().toLowerCase(Locale.ENGLISH);
        }
    }

    public static final class BreakingChangeRule
    implements ToNode {
        private final NodePointer path;
        private final Severity severity;
        private final ChangeType change;
        private final String message;

        public BreakingChangeRule(NodePointer path, Severity severity, ChangeType change, String message) {
            this.path = path;
            this.severity = severity;
            this.change = change;
            this.message = message;
        }

        public Optional<NodePointer> getPath() {
            return Optional.ofNullable(this.path);
        }

        public NodePointer getDefaultedPath() {
            return this.path == null ? NodePointer.empty() : this.path;
        }

        public Optional<Severity> getSeverity() {
            return Optional.ofNullable(this.severity);
        }

        public Severity getDefaultedSeverity() {
            return this.severity == null ? Severity.ERROR : this.severity;
        }

        public ChangeType getChange() {
            return this.change;
        }

        public Optional<String> getMessage() {
            return Optional.ofNullable(this.message);
        }

        public int hashCode() {
            return Objects.hash(this.path, this.severity, this.change, this.message);
        }

        public boolean equals(Object obj) {
            if (obj instanceof BreakingChangeRule) {
                BreakingChangeRule other = (BreakingChangeRule)obj;
                return Objects.equals(this.path, other.path) && Objects.equals(this.severity, other.severity) && Objects.equals(this.message, other.message) && this.change == other.change;
            }
            return false;
        }

        public String toString() {
            return super.toString();
        }

        @Override
        public Node toNode() {
            return Node.objectNodeBuilder().withOptionalMember("path", this.getPath().map(NodePointer::toString).map(Node::from)).withOptionalMember("severity", this.getSeverity().map(Severity::toNode)).withMember("change", this.change.toNode()).withOptionalMember("message", this.getMessage().map(Node::from)).build();
        }

        public static BreakingChangeRule fromNode(Node node) {
            ObjectNode obj = node.expectObjectNode();
            NodePointer path = obj.getStringMember("path").map(NodePointer::fromNode).orElse(null);
            Severity severity = obj.getStringMember("severity").map(Severity::fromNode).orElse(null);
            ChangeType change = ChangeType.fromNode(obj.expectStringMember("change"));
            String message = obj.getStringMemberOrDefault("message", null);
            if (severity == Severity.SUPPRESSED) {
                throw new ExpectationNotMetException("Invalid severity", obj.expectMember("severity"));
            }
            return new BreakingChangeRule(path, severity, change, message);
        }
    }

    public static enum StructurallyExclusive implements ToNode
    {
        MEMBER,
        TARGET;


        public String toString() {
            return super.toString().toLowerCase(Locale.ENGLISH);
        }

        @Override
        public Node toNode() {
            return Node.from(this.toString());
        }

        public static StructurallyExclusive fromNode(Node node) {
            String value = node.expectStringNode().expectOneOf(MEMBER.toString(), TARGET.toString());
            return StructurallyExclusive.valueOf(value.toUpperCase(Locale.ENGLISH));
        }
    }
}

