/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.validation.suppressions;

import java.util.Collection;
import java.util.Optional;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.model.validation.suppressions.Suppression;
import software.amazon.smithy.utils.ListUtils;

final class MetadataSuppression
implements Suppression {
    private static final String ID = "id";
    private static final String NAMESPACE = "namespace";
    private static final String REASON = "reason";
    private static final Collection<String> SUPPRESSION_KEYS = ListUtils.of((Object[])new String[]{"id", "namespace", "reason"});
    private final String id;
    private final String namespace;
    private final String reason;

    MetadataSuppression(String id, String namespace, String reason) {
        this.id = id;
        this.namespace = namespace;
        this.reason = reason;
    }

    static MetadataSuppression fromNode(Node node) {
        ObjectNode rule = node.expectObjectNode();
        rule.warnIfAdditionalProperties(SUPPRESSION_KEYS);
        String id = rule.expectStringMember(ID).getValue();
        String namespace = rule.expectStringMember(NAMESPACE).getValue();
        String reason = rule.getStringMemberOrDefault(REASON, null);
        return new MetadataSuppression(id, namespace, reason);
    }

    @Override
    public boolean test(ValidationEvent event) {
        return event.getId().equals(this.id) && this.matchesNamespace(event);
    }

    @Override
    public Optional<String> getReason() {
        return Optional.ofNullable(this.reason);
    }

    private boolean matchesNamespace(ValidationEvent event) {
        return this.namespace.equals("*") || event.getShapeId().filter(id -> id.getNamespace().equals(this.namespace)).isPresent();
    }
}

