/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.validation.node;

import software.amazon.smithy.model.node.StringNode;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.StringShape;
import software.amazon.smithy.model.traits.LengthTrait;
import software.amazon.smithy.model.validation.node.MemberAndShapeTraitPlugin;
import software.amazon.smithy.model.validation.node.NodeValidatorPlugin;

final class StringLengthPlugin
extends MemberAndShapeTraitPlugin<StringShape, StringNode, LengthTrait> {
    StringLengthPlugin() {
        super(StringShape.class, StringNode.class, LengthTrait.class);
    }

    @Override
    protected void check(Shape shape, LengthTrait trait, StringNode node, NodeValidatorPlugin.Context context, NodeValidatorPlugin.Emitter emitter) {
        trait.getMin().ifPresent(min -> {
            if ((long)node.getValue().length() < min) {
                emitter.accept(node, String.format("String value provided for `%s` must be >= %d characters, but the provided value is only %d characters.", shape.getId(), min, node.getValue().length()));
            }
        });
        trait.getMax().ifPresent(max -> {
            if ((long)node.getValue().length() > max) {
                emitter.accept(node, String.format("String value provided for `%s` must be <= %d characters, but the provided value is %d characters.", shape.getId(), max, node.getValue().length()));
            }
        });
    }
}

