/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.validation.validators;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.NeighborProviderIndex;
import software.amazon.smithy.model.neighbor.NeighborProvider;
import software.amazon.smithy.model.neighbor.Relationship;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.traits.PrivateTrait;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;

public final class PrivateAccessValidator
extends AbstractValidator {
    @Override
    public List<ValidationEvent> validate(Model model) {
        NeighborProvider provider = NeighborProviderIndex.of(model).getReverseProvider();
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        for (Shape privateShape : model.getShapesWithTrait(PrivateTrait.class)) {
            this.validateNeighbors(privateShape, provider.getNeighbors(privateShape), events);
        }
        return events;
    }

    private void validateNeighbors(Shape shape, List<Relationship> relationships, List<ValidationEvent> events) {
        String namespace = shape.getId().getNamespace();
        for (Relationship rel : relationships) {
            if (rel.getShape().getId().getNamespace().equals(namespace)) continue;
            events.add(this.error(rel.getShape(), String.format("This shape has an invalid %s relationship that targets a private shape, `%s`, in another namespace.", rel.getRelationshipType().toString().toLowerCase(Locale.US), rel.getNeighborShape().get().getId())));
        }
    }
}

