/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.validation;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.Formatter;
import software.amazon.smithy.model.SourceLocation;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.model.validation.ValidationEventFormatter;

public final class ContextualValidationEventFormatter
implements ValidationEventFormatter {
    @Override
    public String format(ValidationEvent event) {
        StringWriter writer = new StringWriter();
        Formatter formatter = new Formatter(writer);
        formatter.format("%s: %s (%s)%n", event.getSeverity(), event.getShapeId().map(ShapeId::toString).orElse("-"), event.getId());
        if (event.getSourceLocation() != SourceLocation.NONE) {
            String humanReadableFilename = this.getHumanReadableFilename(event.getSourceLocation());
            String contextualLine = null;
            try {
                contextualLine = this.loadContextualLine(event.getSourceLocation());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (contextualLine == null) {
                formatter.format("     @ %s%n", event.getSourceLocation());
            } else {
                formatter.format("     @ %s%n", humanReadableFilename);
                formatter.format("     |%n", new Object[0]);
                formatter.format("%4d | %s%n", event.getSourceLocation().getLine(), contextualLine);
                formatter.format("     | %" + event.getSourceLocation().getColumn() + "s%n", "^");
            }
        }
        formatter.format("     = %s%n", event.getMessage().replace("\n", "       \n"));
        formatter.flush();
        return writer.toString();
    }

    private String getHumanReadableFilename(SourceLocation source) {
        String filename = source.getFilename();
        if (filename.startsWith("file:")) {
            filename = filename.substring(5);
        }
        return filename;
    }

    private String loadContextualLine(SourceLocation source) throws IOException {
        String normalizedFile = source.getFilename();
        if (!source.getFilename().startsWith("file:") && !source.getFilename().startsWith("jar:")) {
            normalizedFile = "file:" + normalizedFile;
        }
        URL url = new URL(normalizedFile);
        URLConnection connection = url.openConnection();
        connection.setUseCaches(false);
        try (InputStream input = connection.getInputStream();){
            String string;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8));){
                string = reader.lines().skip(source.getLine() - 1).findFirst().orElse(null);
            }
            return string;
        }
    }
}

