/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.knowledge;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.KnowledgeIndex;
import software.amazon.smithy.model.shapes.CollectionShape;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.traits.BoxTrait;

public final class BoxIndex
implements KnowledgeIndex {
    private final Map<ShapeId, Boolean> boxMap;

    public BoxIndex(Model model) {
        this.boxMap = model.shapes().collect(Collectors.toMap(Shape::getId, s -> BoxIndex.isBoxed(model, s), (a, b) -> b, () -> new HashMap(model.toSet().size())));
    }

    public static BoxIndex of(Model model) {
        return model.getKnowledge(BoxIndex.class, BoxIndex::new);
    }

    private static boolean isBoxed(Model model, Shape shape) {
        if (shape.hasTrait(BoxTrait.class)) {
            return true;
        }
        if (shape.isStringShape() || shape.isBlobShape() || shape.isTimestampShape() || shape.isBigDecimalShape() || shape.isBigIntegerShape() || shape instanceof CollectionShape || shape.isMapShape() || shape.isStructureShape() || shape.isUnionShape()) {
            return true;
        }
        if (shape.isMemberShape()) {
            return shape.asMemberShape().map(MemberShape::getTarget).flatMap(model::getShape).filter(target -> BoxIndex.isBoxed(model, target)).isPresent();
        }
        return false;
    }

    public boolean isBoxed(ToShapeId shape) {
        return this.boxMap.get(shape.toShapeId());
    }
}

