/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.validation.validators;

import java.util.ArrayList;
import java.util.List;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.SimpleShape;
import software.amazon.smithy.model.traits.EnumTrait;
import software.amazon.smithy.model.traits.SensitiveTrait;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;

public final class SensitiveTraitValidator
extends AbstractValidator {
    @Override
    public List<ValidationEvent> validate(Model model) {
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        for (MemberShape member : model.getMemberShapesWithTrait(SensitiveTrait.class)) {
            SensitiveTrait trait = member.expectTrait(SensitiveTrait.class);
            model.getShape(member.getTarget()).ifPresent(target -> {
                if (target.hasTrait(SensitiveTrait.class)) {
                    events.add(this.warning(member, trait, "Redundant `sensitive` trait found on member that targets a `sensitive` shape"));
                } else if (this.isBadSensitiveTarget((Shape)target)) {
                    events.add(this.warning(member, trait, "Members marked with the `sensitive` trait should not target shapes that represent concrete data types like structures, unions, or enums. A better approach is to instead mark the targeted shape as sensitive and omit the `sensitive` trait from the member. This helps to prevent modeling mistakes by ensuring every reference to concrete data types that are inherently sensitive are always considered sensitive. Concrete types that are conditionally sensitive should generally be separated into two types: one to represent a sensitive type and one to represent the normal type."));
                }
            });
        }
        return events;
    }

    private boolean isBadSensitiveTarget(Shape target) {
        return !(target instanceof SimpleShape) || target.hasTrait(EnumTrait.class);
    }
}

