/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.loader;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Map;
import java.util.function.Supplier;
import java.util.logging.Logger;
import software.amazon.smithy.model.SourceLocation;
import software.amazon.smithy.model.loader.AstModelLoader;
import software.amazon.smithy.model.loader.CompositeModelFile;
import software.amazon.smithy.model.loader.IdlModelParser;
import software.amazon.smithy.model.loader.LoaderUtils;
import software.amazon.smithy.model.loader.ModelDiscovery;
import software.amazon.smithy.model.loader.ModelFile;
import software.amazon.smithy.model.loader.ModelImportException;
import software.amazon.smithy.model.loader.ModelSyntaxException;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.StringNode;
import software.amazon.smithy.model.traits.TraitFactory;
import software.amazon.smithy.utils.IoUtils;

final class ModelLoader {
    private static final Logger LOGGER = Logger.getLogger(ModelLoader.class.getName());
    private static final String SMITHY = "smithy";

    private ModelLoader() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static ModelFile load(TraitFactory traitFactory, Map<String, Object> properties, String filename, Supplier<InputStream> contentSupplier) {
        try (InputStream inputStream = contentSupplier.get();){
            if (filename.endsWith(".json")) {
                ModelFile modelFile = ModelLoader.loadParsedNode(traitFactory, Node.parse(inputStream, filename));
                return modelFile;
            }
            if (filename.endsWith(".smithy")) {
                String contents = IoUtils.toUtf8String((InputStream)inputStream);
                ModelFile modelFile = new IdlModelParser(traitFactory, filename, contents).parse();
                return modelFile;
            }
            if (filename.endsWith(".jar")) {
                ModelFile modelFile = ModelLoader.loadJar(traitFactory, properties, filename);
                return modelFile;
            }
            if (filename.equals(SourceLocation.NONE.getFilename())) {
                ModelFile modelFile = ModelLoader.loadParsedNode(traitFactory, Node.parse(inputStream, filename));
                return modelFile;
            }
            ModelFile modelFile = null;
            return modelFile;
        }
        catch (IOException e) {
            throw new ModelImportException("Error loading " + filename + ": " + e.getMessage(), e);
        }
    }

    static ModelFile loadParsedNode(TraitFactory traitFactory, Node node) {
        ObjectNode model = node.expectObjectNode("Smithy documents must be an object. Found {type}.");
        StringNode version = model.expectStringMember(SMITHY);
        if (LoaderUtils.isVersionSupported(version.getValue())) {
            return AstModelLoader.INSTANCE.load(traitFactory, model);
        }
        throw new ModelSyntaxException("Unsupported Smithy version number: " + version.getValue(), version);
    }

    private static ModelFile loadJar(TraitFactory traitFactory, Map<String, Object> properties, String filename) {
        ArrayList<ModelFile> modelFiles = new ArrayList<ModelFile>();
        URL manifestUrl = ModelDiscovery.createSmithyJarManifestUrl(filename);
        LOGGER.fine(() -> "Loading Smithy model imports from JAR: " + manifestUrl);
        for (URL model : ModelDiscovery.findModels(manifestUrl)) {
            try {
                ModelFile innerResult;
                URLConnection connection = model.openConnection();
                if (properties.containsKey("assembler.disableJarCache")) {
                    connection.setUseCaches(false);
                }
                if ((innerResult = ModelLoader.load(traitFactory, properties, model.toExternalForm(), () -> {
                    try {
                        return connection.getInputStream();
                    }
                    catch (IOException e) {
                        throw ModelLoader.throwIoJarException(model, e);
                    }
                })) == null) continue;
                modelFiles.add(innerResult);
            }
            catch (IOException e) {
                throw ModelLoader.throwIoJarException(model, e);
            }
        }
        return new CompositeModelFile(traitFactory, modelFiles);
    }

    private static ModelImportException throwIoJarException(URL model, Throwable e) {
        return new ModelImportException(String.format("Error loading Smithy model from URL `%s`: %s", model, e.getMessage()), e);
    }
}

