/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.validation.validators;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.HttpBinding;
import software.amazon.smithy.model.knowledge.HttpBindingIndex;
import software.amazon.smithy.model.knowledge.OperationIndex;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.traits.ErrorTrait;
import software.amazon.smithy.model.traits.HttpPayloadTrait;
import software.amazon.smithy.model.traits.HttpTrait;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.model.validation.ValidationUtils;

public final class HttpPayloadValidator
extends AbstractValidator {
    @Override
    public List<ValidationEvent> validate(Model model) {
        if (!model.isTraitApplied(HttpPayloadTrait.class)) {
            return Collections.emptyList();
        }
        OperationIndex opIndex = model.getKnowledge(OperationIndex.class);
        HttpBindingIndex bindings = model.getKnowledge(HttpBindingIndex.class);
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        events.addAll(model.shapes(OperationShape.class).filter(shape -> shape.getTrait(HttpTrait.class).isPresent()).flatMap(shape -> this.validateOperation(bindings, opIndex, (OperationShape)shape).stream()).collect(Collectors.toList()));
        events.addAll(model.shapes(StructureShape.class).flatMap(shape -> Trait.flatMapStream(shape, ErrorTrait.class)).flatMap(pair -> this.validateError((StructureShape)pair.getLeft(), bindings).stream()).collect(Collectors.toList()));
        return events;
    }

    private List<ValidationEvent> validateOperation(HttpBindingIndex bindings, OperationIndex opIndex, OperationShape shape) {
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        opIndex.getInput(shape.getId()).flatMap(struct -> this.validatePayload(shape.getId(), (StructureShape)struct, bindings, true)).ifPresent(events::add);
        opIndex.getOutput(shape.getId()).flatMap(struct -> this.validatePayload(shape.getId(), (StructureShape)struct, bindings, false)).ifPresent(events::add);
        return events;
    }

    private List<ValidationEvent> validateError(StructureShape shape, HttpBindingIndex bindings) {
        return this.validatePayload(shape.getId(), shape, bindings, false).map(Collections::singletonList).orElseGet(Collections::emptyList);
    }

    private Optional<ValidationEvent> validatePayload(ShapeId subject, StructureShape inputOrError, HttpBindingIndex bindings, boolean request) {
        Map<String, HttpBinding> resolved = request ? bindings.getRequestBindings(subject) : bindings.getResponseBindings(subject);
        Set unbound = resolved.entrySet().stream().filter(binding -> ((HttpBinding)binding.getValue()).getLocation() == HttpBinding.Location.UNBOUND).map(Map.Entry::getKey).collect(Collectors.toSet());
        if (!unbound.isEmpty()) {
            return Optional.of(this.error(inputOrError, String.format("A member of this structure is marked with the `httpPayload` trait, but the following structure members are not explicitly bound to the HTTP message: %s", ValidationUtils.tickedList(unbound))));
        }
        return Optional.empty();
    }
}

