/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.validation.node;

import java.util.function.BiConsumer;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.model.validation.node.NodeValidatorPlugin;

abstract class MemberAndShapeTraitPlugin<S extends Shape, N extends Node, T extends Trait>
implements NodeValidatorPlugin {
    private final Class<S> targetShapeClass;
    private final Class<N> nodeClass;
    private final Class<T> traitClass;

    MemberAndShapeTraitPlugin(Class<S> targetShapeClass, Class<N> nodeClass, Class<T> traitClass) {
        this.targetShapeClass = targetShapeClass;
        this.nodeClass = nodeClass;
        this.traitClass = traitClass;
    }

    @Override
    public final void apply(Shape shape, Node value, Model model, BiConsumer<FromSourceLocation, String> emitter) {
        if (this.nodeClass.isInstance(value) && shape.getTrait(this.traitClass).isPresent() && this.isMatchingShape(shape, model)) {
            this.check(shape, (Trait)shape.getTrait(this.traitClass).get(), value, model, emitter);
        }
    }

    private boolean isMatchingShape(Shape shape, Model model) {
        if (this.targetShapeClass.isInstance(shape)) {
            return true;
        }
        return shape.asMemberShape().flatMap(member -> model.getShape(member.getTarget())).filter(this.targetShapeClass::isInstance).isPresent();
    }

    protected abstract void check(Shape var1, T var2, N var3, Model var4, BiConsumer<FromSourceLocation, String> var5);
}

