/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.loader;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.logging.Logger;
import software.amazon.smithy.model.loader.LoaderUtils;
import software.amazon.smithy.model.loader.MetadataContainer;
import software.amazon.smithy.model.loader.ModelFile;
import software.amazon.smithy.model.loader.TraitContainer;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ShapeType;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.model.traits.TraitFactory;
import software.amazon.smithy.model.validation.ValidationEvent;

final class CompositeModelFile
implements ModelFile {
    private static final Logger LOGGER = Logger.getLogger(CompositeModelFile.class.getName());
    private final TraitFactory traitFactory;
    private final List<ModelFile> modelFiles;
    private final List<ValidationEvent> mergeEvents = new ArrayList<ValidationEvent>();

    CompositeModelFile(TraitFactory traitFactory, List<ModelFile> modelFiles) {
        this.traitFactory = traitFactory;
        this.modelFiles = modelFiles;
    }

    @Override
    public Set<ShapeId> shapeIds() {
        HashSet<ShapeId> ids = new HashSet<ShapeId>();
        for (ModelFile modelFile : this.modelFiles) {
            ids.addAll(modelFile.shapeIds());
        }
        return ids;
    }

    @Override
    public ShapeType getShapeType(ShapeId id) {
        for (ModelFile modFile : this.modelFiles) {
            ShapeType fileType = modFile.getShapeType(id);
            if (fileType == null) continue;
            return fileType;
        }
        return null;
    }

    @Override
    public Map<String, Node> metadata() {
        MetadataContainer metadata = new MetadataContainer(this.mergeEvents);
        for (ModelFile modelFile : this.modelFiles) {
            for (Map.Entry<String, Node> entry : modelFile.metadata().entrySet()) {
                metadata.putMetadata(entry.getKey(), entry.getValue());
            }
        }
        return metadata.getData();
    }

    @Override
    public TraitContainer resolveShapes(Set<ShapeId> ids, Function<ShapeId, ShapeType> typeProvider) {
        TraitContainer.TraitHashMap traitValues = new TraitContainer.TraitHashMap(this.traitFactory, this.mergeEvents);
        for (ModelFile modelFile : this.modelFiles) {
            TraitContainer other = modelFile.resolveShapes(ids, typeProvider);
            for (Map.Entry<ShapeId, Map<ShapeId, Trait>> entry : other.traits().entrySet()) {
                ShapeId target = entry.getKey();
                for (Map.Entry<ShapeId, Trait> appliedEntry : entry.getValue().entrySet()) {
                    traitValues.onTrait(target, appliedEntry.getValue());
                }
            }
        }
        return traitValues;
    }

    @Override
    public Collection<Shape> createShapes(TraitContainer resolvedTraits) {
        HashMap<ShapeId, Shape> shapes = new HashMap<ShapeId, Shape>();
        for (ModelFile modelFile : this.modelFiles) {
            for (Shape shape : modelFile.createShapes(resolvedTraits)) {
                Shape previous = (Shape)shapes.get(shape.getId());
                if (previous == null) {
                    shapes.put(shape.getId(), shape);
                    continue;
                }
                if (!previous.equals(shape)) {
                    this.mergeEvents.add(LoaderUtils.onShapeConflict(shape.getId(), shape.getSourceLocation(), previous.getSourceLocation()));
                    continue;
                }
                LOGGER.warning(() -> "Ignoring duplicate but equivalent shape definition: " + previous.getId() + " defined at " + shape.getSourceLocation() + " and " + previous.getSourceLocation());
            }
        }
        return shapes.values();
    }

    @Override
    public List<ValidationEvent> events() {
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>(this.mergeEvents);
        for (ModelFile modelFile : this.modelFiles) {
            events.addAll(modelFile.events());
        }
        return events;
    }
}

