/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.transform;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.loader.ModelAssembler;
import software.amazon.smithy.model.node.ArrayNode;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.NodeVisitor;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.StringNode;
import software.amazon.smithy.model.shapes.ModelSerializer;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.transform.ModelTransformer;
import software.amazon.smithy.utils.Pair;

final class RenameShapes {
    private final Map<ShapeId, ShapeId> renamed;
    private final ModelAssembler assembler;

    RenameShapes(Map<ShapeId, ShapeId> renamed, Supplier<ModelAssembler> modelAssemblerSupplier) {
        this.renamed = new HashMap<ShapeId, ShapeId>(renamed);
        this.assembler = modelAssemblerSupplier.get();
    }

    Model transform(ModelTransformer transformer, Model model) {
        this.renamed.keySet().removeIf(fromId -> fromId.equals(this.renamed.get(fromId)));
        if (this.renamed.isEmpty()) {
            return model;
        }
        Set<String> toRename = this.renamed.keySet().stream().map(ShapeId::toString).collect(Collectors.toSet());
        ModelSerializer serializer = ModelSerializer.builder().build();
        ObjectNode node = serializer.serialize(model);
        Node newModel = node.accept(new RenameShapeVisitor(toRename, this.renamed));
        return this.assembler.addDocumentNode(newModel).assemble().unwrap();
    }

    private static final class RenameShapeVisitor
    extends NodeVisitor.Default<Node> {
        private final Set<String> toRename;
        private final Map<ShapeId, ShapeId> shapeMapping;

        RenameShapeVisitor(Set<String> toRename, Map<ShapeId, ShapeId> shapeMapping) {
            this.toRename = toRename;
            this.shapeMapping = shapeMapping;
        }

        @Override
        protected Node getDefault(Node node) {
            return node;
        }

        @Override
        public Node arrayNode(ArrayNode node) {
            return node.getElements().stream().map(element -> element.accept(this)).collect(ArrayNode.collect());
        }

        @Override
        public Node objectNode(ObjectNode node) {
            return node.getMembers().entrySet().stream().map(entry -> Pair.of((Object)((StringNode)entry.getKey()).accept(this), (Object)((Node)entry.getValue()).accept(this))).collect(ObjectNode.collect(pair -> ((Node)pair.getLeft()).expectStringNode(), Pair::getRight));
        }

        @Override
        public Node stringNode(StringNode node) {
            if (this.toRename.contains(node.getValue())) {
                ShapeId nodeShapeId = node.expectShapeId();
                return new StringNode(this.shapeMapping.get(nodeShapeId).toString(), node.getSourceLocation());
            }
            return node;
        }
    }
}

