/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.traits;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.StringNode;
import software.amazon.smithy.model.node.ToNode;
import software.amazon.smithy.utils.SmithyBuilder;
import software.amazon.smithy.utils.Tagged;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class EnumDefinition
implements ToNode,
ToSmithyBuilder<EnumDefinition>,
Tagged {
    public static final String VALUE = "value";
    public static final String NAME = "name";
    public static final String DOCUMENTATION = "documentation";
    public static final String TAGS = "tags";
    public static final String DEPRECATED = "deprecated";
    private final String value;
    private final String documentation;
    private final List<String> tags;
    private final String name;
    private final boolean deprecated;

    private EnumDefinition(Builder builder) {
        this.value = (String)SmithyBuilder.requiredState((String)VALUE, (Object)builder.value);
        this.name = builder.name;
        this.documentation = builder.documentation;
        this.tags = new ArrayList<String>(builder.tags);
        this.deprecated = builder.deprecated;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getValue() {
        return this.value;
    }

    public Optional<String> getName() {
        return Optional.ofNullable(this.name);
    }

    public Optional<String> getDocumentation() {
        return Optional.ofNullable(this.documentation);
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }

    @Override
    public Node toNode() {
        ObjectNode.Builder builder = Node.objectNodeBuilder();
        builder.withMember(VALUE, this.getValue()).withOptionalMember(NAME, this.getName().map(Node::from)).withOptionalMember(DOCUMENTATION, this.getDocumentation().map(Node::from));
        if (!this.tags.isEmpty()) {
            builder.withMember(TAGS, Node.fromStrings(this.getTags()));
        }
        if (this.isDeprecated()) {
            builder.withMember(DEPRECATED, true);
        }
        return builder.build();
    }

    public static EnumDefinition fromNode(Node node) {
        ObjectNode value = node.expectObjectNode();
        Builder builder = EnumDefinition.builder().value(value.expectStringMember(VALUE).getValue()).name(value.getStringMember(NAME).map(StringNode::getValue).orElse(null)).documentation(value.getStringMember(DOCUMENTATION).map(StringNode::getValue).orElse(null)).deprecated(value.getBooleanMemberOrDefault(DEPRECATED));
        value.getMember(TAGS).ifPresent(tags -> builder.tags(Node.loadArrayOfString(TAGS, tags)));
        return builder.build();
    }

    public List<String> getTags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return EnumDefinition.builder().name(this.name).value(this.value).tags(this.tags).documentation(this.documentation).deprecated(this.deprecated);
    }

    public boolean equals(Object other) {
        if (!(other instanceof EnumDefinition)) {
            return false;
        }
        EnumDefinition otherEnum = (EnumDefinition)other;
        return this.value.equals(otherEnum.value) && Objects.equals(this.name, otherEnum.name) && Objects.equals(this.documentation, otherEnum.documentation) && this.tags.equals(otherEnum.tags) && this.deprecated == otherEnum.deprecated;
    }

    public int hashCode() {
        return Objects.hash(this.value, this.name, this.tags, this.documentation, this.deprecated);
    }

    public static final class Builder
    implements SmithyBuilder<EnumDefinition> {
        private String value;
        private String documentation;
        private String name;
        private boolean deprecated;
        private final List<String> tags = new ArrayList<String>();

        public EnumDefinition build() {
            return new EnumDefinition(this);
        }

        public Builder value(String value) {
            this.value = Objects.requireNonNull(value);
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder documentation(String documentation) {
            this.documentation = documentation;
            return this;
        }

        public Builder tags(Collection<String> tags) {
            this.tags.clear();
            this.tags.addAll(tags);
            return this;
        }

        public Builder addTag(String tag) {
            this.tags.add(tag);
            return this;
        }

        public Builder clearTags() {
            this.tags.clear();
            return this;
        }

        public Builder deprecated(boolean deprecated) {
            this.deprecated = deprecated;
            return this;
        }
    }
}

