/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.traits;

import java.util.Objects;
import java.util.function.BiFunction;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.SourceLocation;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.StringNode;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.traits.AbstractTrait;

public abstract class StringTrait
extends AbstractTrait {
    private final String value;

    public StringTrait(ShapeId id, String value, FromSourceLocation sourceLocation) {
        super(id, sourceLocation);
        this.value = Objects.requireNonNull(value, "Trait values must not be null");
    }

    public String getValue() {
        return this.value;
    }

    @Override
    protected final Node createNode() {
        return new StringNode(this.value, this.getSourceLocation());
    }

    public static class Provider<T extends StringTrait>
    extends AbstractTrait.Provider {
        private final BiFunction<String, SourceLocation, T> traitFactory;

        public Provider(ShapeId id, BiFunction<String, SourceLocation, T> traitFactory) {
            super(id);
            this.traitFactory = traitFactory;
        }

        public T createTrait(ShapeId id, Node value) {
            return (T)((StringTrait)this.traitFactory.apply(value.expectStringNode().getValue(), value.getSourceLocation()));
        }
    }
}

