/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.neighbor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.neighbor.NeighborVisitor;
import software.amazon.smithy.model.neighbor.Relationship;
import software.amazon.smithy.model.neighbor.RelationshipType;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.utils.ListUtils;

@FunctionalInterface
public interface NeighborProvider {
    public List<Relationship> getNeighbors(Shape var1);

    public static NeighborProvider of(Model model) {
        return new NeighborVisitor(model);
    }

    public static NeighborProvider precomputed(Model model) {
        return NeighborProvider.precomputed(model, NeighborProvider.of(model));
    }

    public static NeighborProvider withTraitRelationships(Model model, NeighborProvider neighborProvider) {
        return shape -> {
            List<Relationship> relationships = neighborProvider.getNeighbors(shape);
            if (shape.getAllTraits().isEmpty()) {
                return relationships;
            }
            relationships = new ArrayList<Relationship>(relationships);
            for (ShapeId trait : shape.getAllTraits().keySet()) {
                Relationship traitRel = model.getShape(trait).map(target -> Relationship.create(shape, RelationshipType.TRAIT, target)).orElseGet(() -> Relationship.createInvalid(shape, RelationshipType.TRAIT, trait));
                relationships.add(traitRel);
            }
            return relationships;
        };
    }

    public static NeighborProvider precomputed(Model model, NeighborProvider provider) {
        HashMap relationships = new HashMap();
        model.shapes().forEach(shape -> relationships.put(shape, provider.getNeighbors((Shape)shape)));
        return shape -> relationships.getOrDefault(shape, ListUtils.of());
    }

    public static NeighborProvider reverse(Model model) {
        return NeighborProvider.reverse(model, NeighborProvider.of(model));
    }

    public static NeighborProvider reverse(Model model, NeighborProvider forwardProvider) {
        Map targetedFrom = model.shapes().map(forwardProvider::getNeighbors).flatMap(Collection::stream).distinct().collect(Collectors.groupingBy(Relationship::getNeighborShapeId, ListUtils.toUnmodifiableList()));
        return shape -> targetedFrom.getOrDefault(shape.getId(), ListUtils.of());
    }

    public static NeighborProvider cached(NeighborProvider provider) {
        ConcurrentHashMap relationships = new ConcurrentHashMap();
        return shape -> relationships.computeIfAbsent(shape, provider::getNeighbors);
    }
}

