/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.validation.node;

import java.util.function.BiConsumer;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.SourceException;
import software.amazon.smithy.model.node.StringNode;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.StringShape;
import software.amazon.smithy.model.traits.IdRefTrait;
import software.amazon.smithy.model.validation.node.MemberAndShapeTraitPlugin;
import software.amazon.smithy.utils.SmithyInternalApi;

@SmithyInternalApi
final class IdRefPlugin
extends MemberAndShapeTraitPlugin<StringShape, StringNode, IdRefTrait> {
    IdRefPlugin() {
        super(StringShape.class, StringNode.class, IdRefTrait.class);
    }

    @Override
    protected void check(Shape shape, IdRefTrait trait, StringNode node, Model model, BiConsumer<FromSourceLocation, String> emitter) {
        try {
            ShapeId target = node.expectShapeId();
            Shape resolved = model.getShape(target).orElse(null);
            if (resolved == null) {
                if (trait.failWhenMissing()) {
                    this.failWhenNoMatch(node, trait, emitter, String.format("Shape ID `%s` was not found in the model", target));
                }
            } else if (!this.matchesSelector(trait, resolved.getId(), model)) {
                this.failWhenNoMatch(node, trait, emitter, String.format("Shape ID `%s` does not match selector `%s`", resolved.getId(), trait.getSelector()));
            }
        }
        catch (SourceException e) {
            emitter.accept(node, e.getMessageWithoutLocation());
        }
    }

    private boolean matchesSelector(IdRefTrait trait, ShapeId needle, Model haystack) {
        return trait.getSelector().select(haystack).stream().map(Shape::getId).anyMatch(shapeId -> shapeId.equals(needle));
    }

    private void failWhenNoMatch(FromSourceLocation location, IdRefTrait trait, BiConsumer<FromSourceLocation, String> emitter, String message) {
        emitter.accept(location, trait.getErrorMessage().orElse(message));
    }
}

