/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.loader;

import software.amazon.smithy.model.SourceLocation;
import software.amazon.smithy.model.loader.IdlModelParser;
import software.amazon.smithy.model.loader.IdlShapeIdParser;
import software.amazon.smithy.model.node.NumberNode;

final class IdlNumberParser {
    private IdlNumberParser() {
    }

    static NumberNode parse(IdlModelParser parser) {
        SourceLocation location = parser.currentLocation();
        String lexeme = IdlNumberParser.parseNumber(parser);
        if (lexeme.contains("e") || lexeme.contains(".")) {
            return new NumberNode(Double.valueOf(lexeme), location);
        }
        return new NumberNode(Long.parseLong(lexeme), location);
    }

    private static String parseNumber(IdlModelParser parser) {
        int startPosition = parser.position();
        char current = parser.charPeek();
        if (current == '-') {
            parser.skip();
            if (!IdlShapeIdParser.isDigit(parser.charPeek())) {
                throw parser.syntax(IdlNumberParser.createInvalidString(parser, startPosition, "'-' must be followed by a digit"));
            }
        }
        parser.consumeUntilNoLongerMatches(IdlShapeIdParser::isDigit);
        char peek = parser.charPeek();
        if (peek == '.') {
            parser.skip();
            if (parser.consumeUntilNoLongerMatches(IdlShapeIdParser::isDigit) == 0) {
                throw parser.syntax(IdlNumberParser.createInvalidString(parser, startPosition, "'.' must be followed by a digit"));
            }
        }
        if ((peek = parser.charPeek()) == 'e' || peek == 'E') {
            parser.skip();
            peek = parser.charPeek();
            if (peek == '+' || peek == '-') {
                parser.skip();
            }
            if (parser.consumeUntilNoLongerMatches(IdlShapeIdParser::isDigit) == 0) {
                throw parser.syntax(IdlNumberParser.createInvalidString(parser, startPosition, "'e', '+', and '-' must be followed by a digit"));
            }
        }
        return parser.sliceFrom(startPosition);
    }

    private static String createInvalidString(IdlModelParser parser, int startPosition, String message) {
        String lexeme = parser.sliceFrom(startPosition);
        return String.format("Invalid number '%s': %s", lexeme, message);
    }
}

