/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.validation.validators;

import java.util.ArrayList;
import java.util.List;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.traits.DeprecatedTrait;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;

public final class DeprecatedTraitValidator
extends AbstractValidator {
    @Override
    public List<ValidationEvent> validate(Model model) {
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        for (Shape trait : model.getShapesWithTrait(DeprecatedTrait.class)) {
            for (Shape shape : model.getShapesWithTrait(trait)) {
                DeprecatedTrait deprecatedTrait = model.expectShape(trait.toShapeId()).expectTrait(DeprecatedTrait.class);
                String traitMessage = trait.toShapeId().toString();
                if (deprecatedTrait.getMessage().isPresent()) {
                    traitMessage = traitMessage + ", " + deprecatedTrait.getMessage().get();
                }
                events.add(this.warning(shape, trait, String.format("This shape applies a trait that is deprecated: %s", traitMessage)));
            }
        }
        return events;
    }
}

