/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.shapes;

import java.util.Optional;
import software.amazon.smithy.model.shapes.BigDecimalShape;
import software.amazon.smithy.model.shapes.BigIntegerShape;
import software.amazon.smithy.model.shapes.BlobShape;
import software.amazon.smithy.model.shapes.BooleanShape;
import software.amazon.smithy.model.shapes.ByteShape;
import software.amazon.smithy.model.shapes.DocumentShape;
import software.amazon.smithy.model.shapes.DoubleShape;
import software.amazon.smithy.model.shapes.FloatShape;
import software.amazon.smithy.model.shapes.IntegerShape;
import software.amazon.smithy.model.shapes.ListShape;
import software.amazon.smithy.model.shapes.LongShape;
import software.amazon.smithy.model.shapes.MapShape;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.ResourceShape;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.SetShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShortShape;
import software.amazon.smithy.model.shapes.StringShape;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.shapes.TimestampShape;
import software.amazon.smithy.model.shapes.UnionShape;

public enum ShapeType {
    BLOB("blob", BlobShape.class),
    BOOLEAN("boolean", BooleanShape.class),
    STRING("string", StringShape.class),
    TIMESTAMP("timestamp", TimestampShape.class),
    BYTE("byte", ByteShape.class),
    SHORT("short", ShortShape.class),
    INTEGER("integer", IntegerShape.class),
    LONG("long", LongShape.class),
    FLOAT("float", FloatShape.class),
    DOCUMENT("document", DocumentShape.class),
    DOUBLE("double", DoubleShape.class),
    BIG_DECIMAL("bigDecimal", BigDecimalShape.class),
    BIG_INTEGER("bigInteger", BigIntegerShape.class),
    LIST("list", ListShape.class),
    SET("set", SetShape.class),
    MAP("map", MapShape.class),
    STRUCTURE("structure", StructureShape.class),
    UNION("union", UnionShape.class),
    SERVICE("service", ServiceShape.class),
    RESOURCE("resource", ResourceShape.class),
    OPERATION("operation", OperationShape.class),
    MEMBER("member", MemberShape.class);

    private final String stringValue;
    private final Class<? extends Shape> shapeClass;

    private ShapeType(String stringValue, Class<? extends Shape> shapeClass) {
        this.stringValue = stringValue;
        this.shapeClass = shapeClass;
    }

    public String toString() {
        return this.stringValue;
    }

    public Class<? extends Shape> getShapeClass() {
        return this.shapeClass;
    }

    public static Optional<ShapeType> fromString(String text) {
        for (ShapeType e : ShapeType.values()) {
            if (!e.stringValue.equals(text)) continue;
            return Optional.of(e);
        }
        return Optional.empty();
    }
}

