/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.pattern;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import software.amazon.smithy.model.pattern.InvalidUriPatternException;
import software.amazon.smithy.model.pattern.SmithyPattern;
import software.amazon.smithy.utils.Pair;

public final class UriPattern
extends SmithyPattern {
    private final Map<String, String> queryLiterals;

    private UriPattern(SmithyPattern.Builder builder, Map<String, String> queryLiterals) {
        super(builder);
        this.queryLiterals = queryLiterals;
    }

    public static UriPattern parse(String uri) {
        if (uri.endsWith("?")) {
            throw new InvalidUriPatternException("URI patterns must not end with '?'. Found " + uri);
        }
        if (!uri.startsWith("/")) {
            throw new InvalidUriPatternException("URI pattern must start with '/'. Found " + uri);
        }
        if (uri.contains("#")) {
            throw new InvalidUriPatternException("URI pattern must not contain a fragment. Found " + uri);
        }
        String[] parts = uri.split(Pattern.quote("?"), 2);
        String[] unparsedSegments = parts[0].split(Pattern.quote("/"));
        ArrayList<SmithyPattern.Segment> segments = new ArrayList<SmithyPattern.Segment>();
        int offset = 1;
        for (int i = 1; i < unparsedSegments.length; ++i) {
            String segment = unparsedSegments[i];
            segments.add(SmithyPattern.Segment.parse(segment, offset));
            offset += segment.length();
        }
        LinkedHashMap<String, String> queryLiterals = new LinkedHashMap<String, String>();
        if (parts.length == 2) {
            if (parts[1].contains("{") || parts[1].contains("}")) {
                throw new InvalidUriPatternException("URI labels must not appear in the query string. Found " + uri);
            }
            for (String kvp : parts[1].split(Pattern.quote("&"))) {
                String[] parameterParts = kvp.split("=", 2);
                String actualKey = parameterParts[0];
                if (queryLiterals.containsKey(actualKey)) {
                    throw new InvalidUriPatternException("Literal query parameters must not be repeated: " + uri);
                }
                queryLiterals.put(actualKey, parameterParts.length == 2 ? parameterParts[1] : "");
            }
        }
        return new UriPattern(UriPattern.builder().pattern(uri).segments(segments), queryLiterals);
    }

    public Map<String, String> getQueryLiterals() {
        return Collections.unmodifiableMap(this.queryLiterals);
    }

    public Optional<String> getQueryLiteralValue(String parameter) {
        return Optional.ofNullable(this.queryLiterals.get(parameter));
    }

    public boolean conflictsWith(UriPattern otherPattern) {
        if (!this.getConflictingLabelSegments(otherPattern).isEmpty()) {
            return true;
        }
        List<SmithyPattern.Segment> segments = this.getSegments();
        List<SmithyPattern.Segment> otherSegments = otherPattern.getSegments();
        if (segments.size() != otherSegments.size()) {
            return false;
        }
        for (int i = 0; i < segments.size(); ++i) {
            SmithyPattern.Segment segment = segments.get(i);
            SmithyPattern.Segment otherSegment = otherSegments.get(i);
            if (segment.isLabel() || otherSegment.isLabel() || segment.getContent().equals(otherSegment.getContent())) continue;
            return false;
        }
        return this.queryLiterals.equals(otherPattern.queryLiterals);
    }

    public List<Pair<SmithyPattern.Segment, SmithyPattern.Segment>> getConflictingLabelSegments(UriPattern otherPattern) {
        ArrayList<Pair<SmithyPattern.Segment, SmithyPattern.Segment>> conflictingSegments = new ArrayList<Pair<SmithyPattern.Segment, SmithyPattern.Segment>>();
        List<SmithyPattern.Segment> segments = this.getSegments();
        List<SmithyPattern.Segment> otherSegments = otherPattern.getSegments();
        int minSize = Math.min(segments.size(), otherSegments.size());
        for (int i = 0; i < minSize; ++i) {
            SmithyPattern.Segment thisSegment = segments.get(i);
            SmithyPattern.Segment otherSegment = otherSegments.get(i);
            if (thisSegment.isLabel() != otherSegment.isLabel()) {
                conflictingSegments.add((Pair<SmithyPattern.Segment, SmithyPattern.Segment>)Pair.of((Object)thisSegment, (Object)otherSegment));
                continue;
            }
            if (thisSegment.isGreedyLabel() != otherSegment.isGreedyLabel()) {
                conflictingSegments.add((Pair<SmithyPattern.Segment, SmithyPattern.Segment>)Pair.of((Object)thisSegment, (Object)otherSegment));
                continue;
            }
            if (thisSegment.isLabel() || thisSegment.getContent().equals(otherSegment.getContent())) continue;
            return conflictingSegments;
        }
        return conflictingSegments;
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof UriPattern)) {
            return false;
        }
        UriPattern otherPattern = (UriPattern)other;
        return super.equals(other) && this.queryLiterals.equals(otherPattern.queryLiterals);
    }

    @Override
    public int hashCode() {
        return super.hashCode() + this.queryLiterals.hashCode();
    }
}

