/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.knowledge;

import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.traits.Trait;

public final class HttpBinding {
    private final MemberShape member;
    private final Location location;
    private final String locationName;
    private final Trait bindingTrait;

    HttpBinding(MemberShape member, Location location, String locationName, Trait bindingTrait) {
        this.member = Objects.requireNonNull(member);
        this.location = Objects.requireNonNull(location);
        this.locationName = Objects.requireNonNull(locationName);
        this.bindingTrait = bindingTrait;
    }

    public MemberShape getMember() {
        return this.member;
    }

    public String getMemberName() {
        return this.member.getMemberName();
    }

    public Location getLocation() {
        return this.location;
    }

    public String getLocationName() {
        return this.locationName;
    }

    public Optional<Trait> getBindingTrait() {
        return Optional.ofNullable(this.bindingTrait);
    }

    public String toString() {
        return this.member.getId() + " @ " + this.location.toString().toLowerCase(Locale.US) + " (" + this.locationName + ")";
    }

    public boolean equals(Object other) {
        if (!(other instanceof HttpBinding)) {
            return false;
        }
        HttpBinding otherBinding = (HttpBinding)other;
        return this.getMember().equals(otherBinding.getMember()) && this.getLocation() == otherBinding.getLocation() && this.getLocationName().equals(otherBinding.getLocationName());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.location, this.member, this.locationName});
    }

    public static enum Location {
        LABEL,
        DOCUMENT,
        PAYLOAD,
        HEADER,
        PREFIX_HEADERS,
        QUERY,
        UNBOUND;

    }
}

