/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.validation.validators;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.IdentifierBindingIndex;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.ResourceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.model.validation.ValidationUtils;
import software.amazon.smithy.utils.FunctionalUtils;
import software.amazon.smithy.utils.OptionalUtils;
import software.amazon.smithy.utils.Pair;

public final class ResourceIdentifierBindingValidator
extends AbstractValidator {
    @Override
    public List<ValidationEvent> validate(Model model) {
        IdentifierBindingIndex bindingIndex = model.getKnowledge(IdentifierBindingIndex.class);
        return Stream.of(model.shapes(ResourceShape.class).flatMap(resource -> this.validateResource(model, (ResourceShape)resource, bindingIndex)), model.shapes(ResourceShape.class).flatMap(resource -> this.validateCollectionBindings(model, (ResourceShape)resource, bindingIndex)), model.shapes(ResourceShape.class).flatMap(resource -> this.validateInstanceBindings(model, (ResourceShape)resource, bindingIndex))).flatMap(Function.identity()).collect(Collectors.toList());
    }

    private Stream<ValidationEvent> validateResource(Model model, ResourceShape parent, IdentifierBindingIndex bindingIndex) {
        return parent.getResources().stream().flatMap(childId -> OptionalUtils.stream(model.getShape((ShapeId)childId).flatMap(Shape::asResourceShape))).flatMap(child -> child.getAllOperations().stream().flatMap(id -> OptionalUtils.stream(model.getShape((ShapeId)id).flatMap(Shape::asOperationShape))).map(operation -> Pair.of((Object)child, (Object)operation))).flatMap(pair -> OptionalUtils.stream(this.validateOperation(parent, (ResourceShape)pair.getLeft(), (OperationShape)pair.getRight(), bindingIndex)));
    }

    private Optional<ValidationEvent> validateOperation(ResourceShape parent, ResourceShape child, OperationShape operation, IdentifierBindingIndex bindingIndex) {
        if (bindingIndex.getOperationBindingType(child, operation) != IdentifierBindingIndex.BindingType.NONE) {
            Set<String> bindings = bindingIndex.getOperationBindings(child, operation).keySet();
            Set missing = parent.getIdentifiers().keySet().stream().filter(FunctionalUtils.not(bindings::contains)).collect(Collectors.toSet());
            if (!missing.isEmpty()) {
                return Optional.of(this.error(operation, String.format("This operation is bound to the `%s` resource, which is a child of the `%s` resource, and it is missing the following resource identifier bindings of `%s`: [%s]", child.getId(), parent.getId(), parent.getId(), ValidationUtils.tickedList(missing))));
            }
        }
        return Optional.empty();
    }

    private Stream<ValidationEvent> validateCollectionBindings(Model model, ResourceShape resource, IdentifierBindingIndex identifierIndex) {
        return resource.getAllOperations().stream().filter(operation -> identifierIndex.getOperationBindingType(resource, (ToShapeId)operation) == IdentifierBindingIndex.BindingType.COLLECTION).flatMap(id -> OptionalUtils.stream(model.getShape((ShapeId)id).flatMap(Shape::asOperationShape))).filter(operation -> this.hasAllIdentifiersBound(resource, (OperationShape)operation, identifierIndex)).map(operation -> this.error((Shape)operation, String.format("This operation is bound as a collection operation on the `%s` resource, but it improperly binds all of the identifiers of the resource to members of the operation input.", resource.getId())));
    }

    private Stream<ValidationEvent> validateInstanceBindings(Model model, ResourceShape resource, IdentifierBindingIndex bindingIndex) {
        return resource.getAllOperations().stream().filter(operation -> bindingIndex.getOperationBindingType(resource, (ToShapeId)operation) == IdentifierBindingIndex.BindingType.INSTANCE).flatMap(id -> OptionalUtils.stream(model.getShape((ShapeId)id).flatMap(Shape::asOperationShape))).filter(operation -> !this.hasAllIdentifiersBound(resource, (OperationShape)operation, bindingIndex)).map(operation -> {
            String expectedIdentifiers = this.createBindingMessage(resource.getIdentifiers());
            String boundIds = this.createBindingMessage(bindingIndex.getOperationBindings(resource, (ToShapeId)operation));
            return this.error((Shape)operation, String.format("This operation does not form a valid instance operation when bound to resource `%s`. All of the identifiers of the resource were not implicitly or explicitly bound to the input of the operation. Expected the following identifier bindings: [%s]. Found the following identifier bindings: [%s]", resource.getId(), expectedIdentifiers, boundIds));
        });
    }

    private boolean hasAllIdentifiersBound(ResourceShape resource, OperationShape operation, IdentifierBindingIndex bindingIndex) {
        return bindingIndex.getOperationBindings(resource, operation).keySet().containsAll(resource.getIdentifiers().keySet());
    }

    private String createBindingMessage(Map<String, ?> bindings) {
        return bindings.entrySet().stream().map(entry -> String.format("required member named `%s` that targets `%s`", entry.getKey(), entry.getValue().toString())).sorted().collect(Collectors.joining(", "));
    }
}

