/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.selector;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import software.amazon.smithy.model.knowledge.NeighborProviderIndex;
import software.amazon.smithy.model.selector.InternalSelector;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.utils.MapUtils;

final class Context {
    NeighborProviderIndex neighborIndex;
    private Map<String, Set<Shape>> variables;

    Context(NeighborProviderIndex neighborIndex) {
        this.neighborIndex = neighborIndex;
        this.variables = new HashMap<String, Set<Shape>>();
    }

    Context clearVars() {
        this.variables.clear();
        return this;
    }

    Map<String, Set<Shape>> copyVars() {
        return MapUtils.copyOf(this.variables);
    }

    Map<String, Set<Shape>> getVars() {
        return this.variables;
    }

    void putVar(String variable, Set<Shape> shapes) {
        this.variables.put(variable, shapes);
    }

    boolean receivedShapes(Shape shape, InternalSelector predicate) {
        Holder holder = new Holder();
        predicate.push(this, shape, holder);
        return holder.set;
    }

    private static final class Holder
    implements InternalSelector.Receiver {
        boolean set;

        private Holder() {
        }

        @Override
        public boolean apply(Context context, Shape shape) {
            this.set = true;
            return false;
        }
    }
}

