/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.node.internal;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import software.amazon.smithy.model.node.ArrayNode;
import software.amazon.smithy.model.node.BooleanNode;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.NodeVisitor;
import software.amazon.smithy.model.node.NullNode;
import software.amazon.smithy.model.node.NumberNode;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.StringNode;
import software.amazon.smithy.model.node.internal.JsonWriter;

final class NodeWriter
implements NodeVisitor<Void> {
    private JsonWriter writer;

    NodeWriter(JsonWriter writer) {
        this.writer = writer;
    }

    @Override
    public Void arrayNode(ArrayNode node) {
        try {
            if (node.isEmpty()) {
                this.writer.writeLiteral("[]");
                return null;
            }
            this.writer.writeArrayOpen();
            Iterator<Node> iterator = node.getElements().iterator();
            while (iterator.hasNext()) {
                iterator.next().accept(this);
                if (!iterator.hasNext()) continue;
                this.writer.writeArraySeparator();
            }
            this.writer.writeArrayClose();
            return null;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Void booleanNode(BooleanNode node) {
        try {
            this.writer.writeLiteral(node.getValue() ? "true" : "false");
            return null;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Void nullNode(NullNode node) {
        try {
            this.writer.writeLiteral("null");
            return null;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Void numberNode(NumberNode node) {
        try {
            this.writer.writeNumber(node.toString());
            return null;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Void objectNode(ObjectNode node) {
        try {
            if (node.isEmpty()) {
                this.writer.writeLiteral("{}");
                return null;
            }
            this.writer.writeObjectOpen();
            Iterator<Map.Entry<StringNode, Node>> iterator = node.getMembers().entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<StringNode, Node> entry = iterator.next();
                this.writer.writeMemberName(entry.getKey().getValue());
                this.writer.writeMemberSeparator();
                entry.getValue().accept(this);
                if (!iterator.hasNext()) continue;
                this.writer.writeObjectSeparator();
            }
            this.writer.writeObjectClose();
            return null;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Void stringNode(StringNode node) {
        try {
            this.writer.writeString(node.getValue());
            return null;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

