/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.shapes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.function.Consumer;
import software.amazon.smithy.model.shapes.AbstractShapeBuilder;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;

abstract class NamedMembersShape
extends Shape {
    private final Map<String, MemberShape> members;

    NamedMembersShape(Builder<?, ?> builder) {
        super(builder, false);
        assert (builder.members != null);
        this.members = Collections.unmodifiableMap(new TreeMap<String, MemberShape>(builder.members));
        this.members.forEach((key, value) -> {
            ShapeId expected = this.getId().withMember((String)key);
            if (!value.getId().equals(expected)) {
                throw new IllegalArgumentException(String.format("Expected the `%s` member of `%s` to have an ID of `%s` but found `%s`", key, this.getId(), expected, value.getId()));
            }
        });
    }

    public Map<String, MemberShape> getAllMembers() {
        return this.members;
    }

    public List<String> getMemberNames() {
        return new ArrayList<String>(this.members.keySet());
    }

    public Optional<MemberShape> getMember(String name) {
        return Optional.ofNullable(this.members.get(name));
    }

    @Override
    public Collection<MemberShape> members() {
        return this.members.values();
    }

    @Override
    public boolean equals(Object other) {
        return super.equals(other) && this.members.equals(((NamedMembersShape)other).members);
    }

    static abstract class Builder<B extends Builder, S extends NamedMembersShape>
    extends AbstractShapeBuilder<B, S> {
        Map<String, MemberShape> members = new HashMap<String, MemberShape>();

        Builder() {
        }

        public B members(Collection<MemberShape> members) {
            this.members.clear();
            for (MemberShape member : members) {
                this.addMember(member);
            }
            return (B)this;
        }

        public B clearMembers() {
            this.members.clear();
            return (B)this;
        }

        @Override
        public B addMember(MemberShape member) {
            this.members.put(member.getMemberName(), member);
            return (B)this;
        }

        public B addMember(String memberName, ShapeId target) {
            return this.addMember(memberName, target, null);
        }

        public B addMember(String memberName, ShapeId target, Consumer<MemberShape.Builder> memberUpdater) {
            if (this.getId() == null) {
                throw new IllegalStateException("An id must be set before setting a member with a target");
            }
            MemberShape.Builder builder = (MemberShape.Builder)MemberShape.builder().target(target).id(this.getId().withMember(memberName));
            if (memberUpdater != null) {
                memberUpdater.accept(builder);
            }
            return (B)this.addMember(builder.build());
        }

        public B removeMember(String member) {
            this.members.remove(member);
            return (B)this;
        }
    }
}

