/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.loader;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.function.Supplier;
import java.util.logging.Logger;
import software.amazon.smithy.model.SourceLocation;
import software.amazon.smithy.model.loader.AstModelLoader;
import software.amazon.smithy.model.loader.IdlModelLoader;
import software.amazon.smithy.model.loader.LoaderVisitor;
import software.amazon.smithy.model.loader.ModelDiscovery;
import software.amazon.smithy.model.loader.ModelImportException;
import software.amazon.smithy.model.loader.ModelSyntaxException;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.StringNode;

final class ModelLoader {
    private static final Logger LOGGER = Logger.getLogger(ModelLoader.class.getName());
    private static final String SMITHY = "smithy";

    private ModelLoader() {
    }

    static boolean load(String filename, Supplier<InputStream> contentSupplier, LoaderVisitor visitor) {
        if (filename.endsWith(".json")) {
            return ModelLoader.loadParsedNode(Node.parse(contentSupplier.get(), filename), visitor);
        }
        if (filename.endsWith(".smithy")) {
            IdlModelLoader.load(filename, contentSupplier, visitor);
            return true;
        }
        if (filename.endsWith(".jar")) {
            return ModelLoader.loadJar(filename, visitor);
        }
        if (filename.equals(SourceLocation.NONE.getFilename())) {
            return ModelLoader.loadParsedNode(Node.parse(contentSupplier.get(), filename), visitor);
        }
        return false;
    }

    static boolean loadParsedNode(Node node, LoaderVisitor visitor) {
        ObjectNode model = node.expectObjectNode("Smithy documents must be an object. Found {type}.");
        StringNode version = model.expectStringMember(SMITHY);
        if (visitor.isVersionSupported(version.getValue())) {
            AstModelLoader.INSTANCE.load(model, visitor);
            return true;
        }
        throw new ModelSyntaxException("Unsupported Smithy version number: " + version.getValue(), version);
    }

    private static boolean loadJar(String filename, LoaderVisitor visitor) {
        URL manifestUrl = ModelDiscovery.createSmithyJarManifestUrl(filename);
        LOGGER.fine(() -> "Loading Smithy model imports from JAR: " + manifestUrl);
        for (URL model : ModelDiscovery.findModels(manifestUrl)) {
            try {
                URLConnection connection = model.openConnection();
                if (visitor.hasProperty("assembler.disableJarCache")) {
                    connection.setUseCaches(false);
                }
                ModelLoader.load(model.toExternalForm(), () -> {
                    try {
                        return connection.getInputStream();
                    }
                    catch (IOException e) {
                        throw ModelLoader.throwIoJarException(model, e);
                    }
                }, visitor);
            }
            catch (IOException e) {
                throw ModelLoader.throwIoJarException(model, e);
            }
        }
        return true;
    }

    private static ModelImportException throwIoJarException(URL model, Throwable e) {
        return new ModelImportException(String.format("Error loading Smithy model from URL `%s`: %s", model, e.getMessage()), e);
    }
}

