/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.validation.validators;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.HttpBinding;
import software.amazon.smithy.model.knowledge.HttpBindingIndex;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.traits.HttpTrait;
import software.amazon.smithy.model.traits.IdempotentTrait;
import software.amazon.smithy.model.traits.ReadonlyTrait;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.model.validation.ValidationUtils;
import software.amazon.smithy.utils.MapUtils;

public final class HttpMethodSemanticsValidator
extends AbstractValidator {
    private static final Map<String, HttpMethodSemantics> EXPECTED = MapUtils.of((Object)"GET", (Object)new HttpMethodSemantics(true, false, false), (Object)"HEAD", (Object)new HttpMethodSemantics(true, false, false), (Object)"OPTIONS", (Object)new HttpMethodSemantics(true, false, false), (Object)"TRACE", (Object)new HttpMethodSemantics(true, false, false), (Object)"POST", (Object)new HttpMethodSemantics(false, null, true), (Object)"DELETE", (Object)new HttpMethodSemantics(false, true, true), (Object)"PUT", (Object)new HttpMethodSemantics(false, true, true), (Object)"PATCH", (Object)new HttpMethodSemantics(false, false, true));

    @Override
    public List<ValidationEvent> validate(Model model) {
        HttpBindingIndex bindingIndex = model.getKnowledge(HttpBindingIndex.class);
        return model.shapes(OperationShape.class).flatMap(shape -> Trait.flatMapStream(shape, HttpTrait.class)).flatMap(pair -> this.validateOperation(bindingIndex, (OperationShape)pair.getLeft(), (HttpTrait)pair.getRight()).stream()).collect(Collectors.toList());
    }

    private List<ValidationEvent> validateOperation(HttpBindingIndex bindingIndex, OperationShape shape, HttpTrait trait) {
        String method = trait.getMethod().toUpperCase(Locale.US);
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        if (!EXPECTED.containsKey(method)) {
            return events;
        }
        HttpMethodSemantics semantics = EXPECTED.get(method);
        boolean isReadonly = shape.getTrait(ReadonlyTrait.class).isPresent();
        if (semantics.isReadonly != null && semantics.isReadonly != isReadonly) {
            events.add(this.warning(shape, trait, String.format("This operation uses the `%s` method in the `http` trait, but %s marked with the readonly trait", method, isReadonly ? "is" : "is not")));
        }
        boolean isIdempotent = shape.getTrait(IdempotentTrait.class).isPresent();
        if (semantics.isIdempotent != null && semantics.isIdempotent != isIdempotent) {
            events.add(this.warning(shape, trait, String.format("This operation uses the `%s` method in the `http` trait, but %s marked with the idempotent trait", method, isIdempotent ? "is" : "is not")));
        }
        List<HttpBinding> payloadBindings = bindingIndex.getRequestBindings(shape, HttpBinding.Location.PAYLOAD);
        List<HttpBinding> documentBindings = bindingIndex.getRequestBindings(shape, HttpBinding.Location.DOCUMENT);
        if (!(semantics.allowsRequestPayload == null || semantics.allowsRequestPayload.booleanValue() || payloadBindings.isEmpty() && documentBindings.isEmpty())) {
            String document = payloadBindings.isEmpty() ? "document" : "payload";
            payloadBindings.addAll(documentBindings);
            events.add(this.danger(shape, trait, String.format("This operation uses the `%s` method in the `http` trait, but has the following members bound to the %s: %s", method, document, ValidationUtils.tickedList(payloadBindings.stream().map(HttpBinding::getMemberName)))));
        }
        return events;
    }

    private static final class HttpMethodSemantics {
        private final Boolean isReadonly;
        private final Boolean isIdempotent;
        private final Boolean allowsRequestPayload;

        private HttpMethodSemantics(Boolean isReadonly, Boolean isIdempotent, Boolean allowsRequestPayload) {
            this.isReadonly = isReadonly;
            this.isIdempotent = isIdempotent;
            this.allowsRequestPayload = allowsRequestPayload;
        }
    }
}

