/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.traits;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.SourceException;
import software.amazon.smithy.model.SourceLocation;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.traits.StringTrait;

public final class PatternTrait
extends StringTrait {
    public static final ShapeId ID = ShapeId.from("smithy.api#pattern");
    private final Pattern pattern;

    public PatternTrait(String value, SourceLocation sourceLocation) {
        super(ID, value, sourceLocation);
        this.pattern = PatternTrait.compilePattern(value, sourceLocation);
    }

    public PatternTrait(String value) {
        this(value, SourceLocation.NONE);
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    private static Pattern compilePattern(String value, FromSourceLocation sourceLocation) {
        try {
            return Pattern.compile(value);
        }
        catch (PatternSyntaxException e) {
            throw new SourceException("Invalid pattern trait regular expression: `" + value + "`. " + e.getMessage(), sourceLocation);
        }
    }

    public static final class Provider
    extends StringTrait.Provider<PatternTrait> {
        public Provider() {
            super(ID, PatternTrait::new);
        }
    }
}

