/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.shapes;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.utils.MapUtils;
import software.amazon.smithy.utils.SmithyBuilder;
import software.amazon.smithy.utils.ToSmithyBuilder;

@Deprecated
public final class ShapeIndex
implements ToSmithyBuilder<ShapeIndex> {
    private final Map<ShapeId, Shape> shapeMap;
    private int hash;

    private ShapeIndex(Builder builder) {
        this.shapeMap = MapUtils.copyOf((Map)builder.shapeMap);
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return ShapeIndex.builder().addShapes(this);
    }

    public Optional<Shape> getShape(ShapeId id) {
        return Optional.ofNullable(this.shapeMap.get(id));
    }

    public Stream<Shape> shapes() {
        return this.shapeMap.values().stream();
    }

    public <T extends Shape> Stream<T> shapes(Class<T> shapeType) {
        return this.shapeMap.values().stream().filter(value -> value.getClass() == shapeType);
    }

    public Set<Shape> toSet() {
        return new AbstractSet<Shape>(){

            @Override
            public int size() {
                return ShapeIndex.this.shapeMap.size();
            }

            @Override
            public boolean contains(Object o) {
                return o instanceof Shape && ShapeIndex.this.shapeMap.containsKey(((Shape)o).getId());
            }

            @Override
            public Iterator<Shape> iterator() {
                return ShapeIndex.this.shapeMap.values().iterator();
            }
        };
    }

    public int hashCode() {
        int result = this.hash;
        if (result == 0) {
            this.hash = result = this.shapeMap.keySet().hashCode();
        }
        return result;
    }

    public boolean equals(Object other) {
        return other instanceof ShapeIndex && this.shapeMap.equals(((ShapeIndex)other).shapeMap);
    }

    public static final class Builder
    implements SmithyBuilder<ShapeIndex> {
        private final Map<ShapeId, Shape> shapeMap = new HashMap<ShapeId, Shape>();

        private Builder() {
        }

        public ShapeIndex build() {
            return new ShapeIndex(this);
        }

        public Builder addShape(Shape shape) {
            if (!shape.isMemberShape()) {
                this.shapeMap.put(shape.getId(), shape);
                for (MemberShape memberShape : shape.members()) {
                    this.shapeMap.put(memberShape.getId(), memberShape);
                }
            }
            return this;
        }

        public Builder addShapes(ShapeIndex shapeIndex) {
            this.shapeMap.putAll(shapeIndex.shapeMap);
            return this;
        }

        public <S extends Shape> Builder addShapes(Collection<S> shapes) {
            for (Shape shape : shapes) {
                this.addShape(shape);
            }
            return this;
        }

        public Builder addShapes(Shape ... shapes) {
            for (Shape shape : shapes) {
                this.addShape(shape);
            }
            return this;
        }

        public Builder removeShape(ShapeId shapeId) {
            if (this.shapeMap.containsKey(shapeId)) {
                Shape previous = this.shapeMap.get(shapeId);
                this.shapeMap.remove(shapeId);
                for (MemberShape memberShape : previous.members()) {
                    this.shapeMap.remove(memberShape.getId());
                }
            }
            return this;
        }
    }
}

