/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.shapes;

import java.util.Objects;
import java.util.Optional;
import software.amazon.smithy.model.shapes.ShapeIdSyntaxException;
import software.amazon.smithy.model.shapes.ToShapeId;

public final class ShapeId
implements ToShapeId,
Comparable<ShapeId> {
    private final String namespace;
    private final String name;
    private final String member;
    private final String absoluteName;
    private final int hash;

    private ShapeId(String absoluteName, String namespace, String name, String member) {
        this.namespace = namespace;
        this.name = name;
        this.member = member;
        this.absoluteName = absoluteName;
        this.hash = 17 + 31 * namespace.hashCode() * 31 + name.hashCode() * 17 + Objects.hashCode(member);
    }

    private ShapeId(String namespace, String name, String member) {
        this(ShapeId.buildAbsoluteIdFromParts(namespace, name, member), namespace, name, member);
    }

    public static ShapeId from(String absoluteShapeId) {
        String name;
        int namespacePosition = absoluteShapeId.indexOf(35);
        if (namespacePosition <= 0 || namespacePosition == absoluteShapeId.length() - 1) {
            throw new ShapeIdSyntaxException("Invalid shape ID: " + absoluteShapeId);
        }
        String namespace = absoluteShapeId.substring(0, namespacePosition);
        String memberName = null;
        int memberPosition = absoluteShapeId.indexOf(36);
        if (memberPosition == -1) {
            name = absoluteShapeId.substring(namespacePosition + 1);
        } else {
            if (memberPosition < namespacePosition) {
                throw new ShapeIdSyntaxException("Invalid shape ID: " + absoluteShapeId);
            }
            name = absoluteShapeId.substring(namespacePosition + 1, memberPosition);
            memberName = absoluteShapeId.substring(memberPosition + 1);
        }
        return ShapeId.fromParts(namespace, name, memberName);
    }

    public static boolean isValidNamespace(CharSequence namespace) {
        if (namespace == null) {
            return false;
        }
        int position = 0;
        boolean start = true;
        while (position < namespace.length()) {
            char c = namespace.charAt(position++);
            if (start) {
                start = false;
                if (ShapeId.isValidIdentifierStart(c)) continue;
                return false;
            }
            if (c == '.') {
                start = true;
                continue;
            }
            if (ShapeId.isValidIdentifierAfterStart(c)) continue;
            return false;
        }
        return !start;
    }

    public static boolean isValidIdentifier(CharSequence identifier) {
        if (identifier == null || identifier.length() == 0) {
            return false;
        }
        if (!ShapeId.isValidIdentifierStart(identifier.charAt(0))) {
            return false;
        }
        for (int i = 1; i < identifier.length(); ++i) {
            if (ShapeId.isValidIdentifierAfterStart(identifier.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean isValidIdentifierStart(char c) {
        return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c == '_';
    }

    private static boolean isValidIdentifierAfterStart(char c) {
        return ShapeId.isValidIdentifierStart(c) || c >= '0' && c <= '9';
    }

    public static ShapeId fromParts(String namespace, String name, String member) {
        String idFromParts = ShapeId.buildAbsoluteIdFromParts(namespace, name, member);
        if (!ShapeId.isValidNamespace(namespace) || !ShapeId.isValidIdentifier(name) || member != null && !ShapeId.isValidIdentifier(member)) {
            throw new ShapeIdSyntaxException("Invalid shape ID: " + idFromParts);
        }
        return new ShapeId(idFromParts, namespace, name, member);
    }

    private static String buildAbsoluteIdFromParts(String namespace, String name, String member) {
        StringBuilder builder = new StringBuilder(namespace).append('#').append(name);
        if (member != null) {
            builder.append('$').append(member);
        }
        return builder.toString();
    }

    public static ShapeId fromParts(String namespace, String name) {
        return ShapeId.fromParts(namespace, name, null);
    }

    public static ShapeId fromRelative(String namespace, String relativeName) {
        Objects.requireNonNull(namespace, "Shape ID namespace must not be null");
        Objects.requireNonNull(relativeName, "Shape ID relative name must not be null");
        if (relativeName.contains("#")) {
            throw new ShapeIdSyntaxException("Relative shape ID must not contain a namespace: " + relativeName);
        }
        return ShapeId.from(namespace + "#" + relativeName);
    }

    public static ShapeId fromOptionalNamespace(String defaultNamespace, String shapeName) {
        Objects.requireNonNull(shapeName, "Shape name must not be null");
        if (defaultNamespace == null || shapeName.contains("#")) {
            return ShapeId.from(shapeName);
        }
        return ShapeId.fromRelative(defaultNamespace, shapeName);
    }

    public ShapeId withMember(String member) {
        if (!ShapeId.isValidIdentifier(member)) {
            throw new ShapeIdSyntaxException("Invalid shape ID member: " + member);
        }
        return new ShapeId(this.namespace, this.name, member);
    }

    @Override
    public ShapeId toShapeId() {
        return this;
    }

    @Override
    public int compareTo(ShapeId other) {
        return this.toString().compareTo(other.toString());
    }

    public ShapeId withoutMember() {
        return new ShapeId(this.namespace, this.name, null);
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getName() {
        return this.name;
    }

    public Optional<String> getMember() {
        return Optional.ofNullable(this.member);
    }

    public String asRelativeReference() {
        return this.member == null ? this.name : this.name + "$" + this.member;
    }

    public String toString() {
        return this.absoluteName;
    }

    public boolean equals(Object other) {
        return other instanceof ShapeId && other.toString().equals(this.toString());
    }

    public int hashCode() {
        return this.hash;
    }
}

