/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.smithy.model.SourceLocation;
import software.amazon.smithy.model.knowledge.KnowledgeIndex;
import software.amazon.smithy.model.loader.ModelAssembler;
import software.amazon.smithy.model.node.ExpectationNotMetException;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ShapeIndex;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.model.traits.TraitDefinition;
import software.amazon.smithy.model.traits.TraitFactory;
import software.amazon.smithy.model.validation.ValidatorFactory;
import software.amazon.smithy.utils.MapUtils;
import software.amazon.smithy.utils.Pair;
import software.amazon.smithy.utils.SmithyBuilder;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class Model
implements ToSmithyBuilder<Model> {
    public static final String MODEL_VERSION = "0.5.0";
    private final Map<String, Node> metadata;
    private final ShapeIndex shapeIndex;
    private volatile Map<Shape, TraitDefinition> traitDefinitions;
    private final Map<Class<? extends KnowledgeIndex>, KnowledgeIndex> blackboard = new ConcurrentHashMap<Class<? extends KnowledgeIndex>, KnowledgeIndex>();
    private int hash;

    private Model(Builder builder) {
        this.shapeIndex = builder.shapeIndex != null ? builder.shapeIndex : ShapeIndex.builder().build();
        this.metadata = builder.metadata.isEmpty() ? MapUtils.of() : MapUtils.copyOf((Map)builder.metadata);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ModelAssembler assembler() {
        return new ModelAssembler();
    }

    public static ModelAssembler assembler(ClassLoader classLoader) {
        return new ModelAssembler().traitFactory(TraitFactory.createServiceFactory(classLoader)).validatorFactory(ValidatorFactory.createServiceFactory(classLoader));
    }

    @Deprecated
    public ShapeIndex getShapeIndex() {
        return this.shapeIndex;
    }

    public Optional<Node> getMetadataProperty(String name) {
        return Optional.ofNullable(this.metadata.get(name));
    }

    public Map<String, Node> getMetadata() {
        return this.metadata;
    }

    public Map<Shape, TraitDefinition> getTraitDefinitions() {
        if (this.traitDefinitions == null) {
            this.traitDefinitions = Collections.unmodifiableMap(this.shapeIndex.shapes().flatMap(shape -> Trait.flatMapStream(shape, TraitDefinition.class)).collect(Collectors.toMap(Pair::getLeft, Pair::getRight)));
        }
        return this.traitDefinitions;
    }

    public Optional<TraitDefinition> getTraitDefinition(ToShapeId traitId) {
        return this.shapeIndex.getShape(traitId.toShapeId()).flatMap(shape -> shape.getTrait(TraitDefinition.class));
    }

    public Optional<TraitDefinition> getTraitDefinition(String traitId) {
        return this.getTraitDefinition(ShapeId.from(Trait.makeAbsoluteName(traitId)));
    }

    public Collection<Shape> getTraitShapes() {
        return this.getTraitDefinitions().keySet();
    }

    public Optional<Shape> getShape(ShapeId id) {
        return this.shapeIndex.getShape(id);
    }

    public Shape expectShape(ShapeId id) {
        return this.getShape(id).orElseThrow(() -> new ExpectationNotMetException("Shape not found in model: " + id, SourceLocation.NONE));
    }

    public <T extends Shape> T expectShape(ShapeId id, Class<T> type) {
        Shape shape = this.expectShape(id);
        if (type.isInstance(shape)) {
            return (T)shape;
        }
        throw new ExpectationNotMetException(String.format("Expected shape `%s` to be an instance of `%s`, but found `%s`", new Object[]{id, type.getSimpleName(), shape.getType()}), shape);
    }

    public Stream<Shape> shapes() {
        return this.shapeIndex.shapes();
    }

    public <T extends Shape> Stream<T> shapes(Class<T> shapeType) {
        return this.shapeIndex.shapes(shapeType);
    }

    public Set<Shape> toSet() {
        return this.shapeIndex.toSet();
    }

    public boolean equals(Object other) {
        if (!(other instanceof Model)) {
            return false;
        }
        if (other == this) {
            return true;
        }
        Model otherModel = (Model)other;
        return this.getMetadata().equals(otherModel.getMetadata()) && this.getShapeIndex().equals(otherModel.getShapeIndex());
    }

    public int hashCode() {
        int result = this.hash;
        if (result == 0) {
            this.hash = result = Objects.hash(this.getMetadata(), this.shapeIndex);
        }
        return result;
    }

    public Builder toBuilder() {
        return Model.builder().metadata(this.getMetadata()).shapeIndex(this.getShapeIndex());
    }

    public <T extends KnowledgeIndex> T getKnowledge(Class<T> type) {
        KnowledgeIndex value = this.blackboard.get(type);
        if (value == null) {
            value = KnowledgeIndex.create(type, this);
            this.blackboard.put(type, value);
        }
        return (T)value;
    }

    public static final class Builder
    implements SmithyBuilder<Model> {
        private Map<String, Node> metadata = new HashMap<String, Node>();
        private ShapeIndex shapeIndex;
        private ShapeIndex.Builder shapeIndexBuilder;

        private Builder() {
        }

        public Builder metadata(Map<String, Node> metadata) {
            this.clearMetadata();
            this.metadata.putAll(metadata);
            return this;
        }

        public Builder putMetadataProperty(String key, Node value) {
            this.metadata.put(Objects.requireNonNull(key), Objects.requireNonNull(value));
            return this;
        }

        public Builder clearMetadata() {
            this.metadata.clear();
            return this;
        }

        @Deprecated
        public Builder shapeIndex(ShapeIndex shapeIndex) {
            this.shapeIndex = Objects.requireNonNull(shapeIndex);
            this.shapeIndexBuilder = null;
            return this;
        }

        public Builder addShape(Shape shape) {
            this.getShapeIndexBuilder().addShape(shape);
            return this;
        }

        private ShapeIndex.Builder getShapeIndexBuilder() {
            if (this.shapeIndexBuilder == null) {
                if (this.shapeIndex != null) {
                    this.shapeIndexBuilder = this.shapeIndex.toBuilder();
                    this.shapeIndex = null;
                } else {
                    this.shapeIndexBuilder = ShapeIndex.builder();
                }
            }
            return this.shapeIndexBuilder;
        }

        public Builder addShapes(Model model) {
            this.getShapeIndexBuilder().addShapes(model.shapeIndex);
            return this;
        }

        public <S extends Shape> Builder addShapes(Collection<S> shapes) {
            for (Shape shape : shapes) {
                this.addShape(shape);
            }
            return this;
        }

        public Builder addShapes(Shape ... shapes) {
            for (Shape shape : shapes) {
                this.addShape(shape);
            }
            return this;
        }

        public Builder removeShape(ShapeId shapeId) {
            this.getShapeIndexBuilder().removeShape(shapeId);
            return this;
        }

        public Model build() {
            if (this.shapeIndexBuilder != null) {
                this.shapeIndex = this.shapeIndexBuilder.build();
            }
            return new Model(this);
        }
    }
}

