/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.validation.validators;

import java.util.List;
import java.util.stream.Collectors;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.model.validation.NodeValidationVisitor;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.model.validation.Validator;
import software.amazon.smithy.utils.ListUtils;
import software.amazon.smithy.utils.Pair;

public final class TraitValueValidator
implements Validator {
    private static final String NAME = "TraitValue";

    @Override
    public List<ValidationEvent> validate(Model model) {
        return model.shapes().flatMap(shape -> shape.getAllTraits().values().stream().map(t -> Pair.of((Object)shape, (Object)t))).flatMap(pair -> this.validateTrait(model, (Shape)pair.left, (Trait)pair.right).stream()).collect(Collectors.toList());
    }

    private List<ValidationEvent> validateTrait(Model model, Shape targetShape, Trait trait) {
        ShapeId shape = trait.toShapeId();
        if (!model.getShape(shape).isPresent()) {
            return ListUtils.of();
        }
        Shape schema = model.getShape(shape).get();
        Node coerced = Trait.coerceTraitValue(trait.toNode(), schema.getType());
        NodeValidationVisitor cases = NodeValidationVisitor.builder().model(model).value(coerced).eventShapeId(targetShape.getId()).eventId(NAME).startingContext("Error validating trait `" + Trait.getIdiomaticTraitName(trait) + "`").build();
        return schema.accept(cases);
    }
}

