/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.validation.node;

import java.util.ArrayList;
import java.util.List;
import software.amazon.smithy.model.node.StringNode;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeIndex;
import software.amazon.smithy.model.shapes.StringShape;
import software.amazon.smithy.model.traits.LengthTrait;
import software.amazon.smithy.model.validation.node.MemberAndShapeTraitPlugin;

public final class StringLengthPlugin
extends MemberAndShapeTraitPlugin<StringShape, StringNode, LengthTrait> {
    public StringLengthPlugin() {
        super(StringShape.class, StringNode.class, LengthTrait.class);
    }

    @Override
    protected List<String> check(Shape shape, LengthTrait trait, StringNode node, ShapeIndex index) {
        ArrayList<String> messages = new ArrayList<String>();
        trait.getMin().ifPresent(min -> {
            if ((long)node.getValue().length() < min) {
                messages.add(String.format("String value provided for `%s` must be >= %d characters, but the provided value is only %d characters.", shape.getId(), min, node.getValue().length()));
            }
        });
        trait.getMax().ifPresent(max -> {
            if ((long)node.getValue().length() > max) {
                messages.add(String.format("String value provided for `%s` must be <= %d characters, but the provided value is %d characters.", shape.getId(), max, node.getValue().length()));
            }
        });
        return messages;
    }
}

